/*
 * Decompiled with CFR 0.152.
 */
package jason.compiler;

import jason.compiler.Method;
import jason.compiler.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Vector;

public class Parser {
    private String packageName;
    private String interfaceName;
    private Vector roles = new Vector();
    private Vector methods = new Vector();
    private Vector imports;
    String contents;
    String strippedFromComments;
    int parseIndex;
    int line;

    private Parser() {
    }

    public Parser(File file) throws IOException {
        this();
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        this.contents = stringBuffer.toString();
    }

    public Parser(String string) {
        this();
        this.contents = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws ParseException {
        this.parseIndex = 0;
        this.line = 1;
        this.stripComments();
        String string = this.nextToken();
        if (string.equals("package")) {
            this.packageName = this.nextToken();
            if (!this.nextToken().equals(";")) {
                throw new ParseException("Semicolon expected", this.line);
            }
            string = this.nextToken();
        }
        while (string.equals("import")) {
            if (this.imports == null) {
                this.imports = new Vector();
            }
            this.imports.add(this.nextToken());
            if (!this.nextToken().equals(";")) {
                throw new ParseException("Semicolon expected, found: " + string, this.line);
            }
            string = this.nextToken();
        }
        if (!string.equals("public")) throw new ParseException("public expected, found: " + string, this.line);
        string = this.nextToken();
        if (!string.equals("interface")) throw new ParseException("interface expected, found: " + string, this.line);
        this.interfaceName = this.nextToken();
        if (!this.nextToken().equals("{")) {
            throw new ParseException("{ expected", this.line);
        }
        string = this.nextToken();
        while (!string.equals("}")) {
            if (string.equals("roles")) {
                this.roles.add(this.nextToken());
                string = this.nextToken();
                while (string.equals(",")) {
                    this.roles.add(this.nextToken());
                    string = this.nextToken();
                }
                if (!string.equals(";")) {
                    throw new ParseException("semicolon expected", this.line);
                }
                string = this.nextToken();
                continue;
            }
            if (string.equals("}")) continue;
            Method method = new Method();
            if (string.equals("accessible")) {
                if (!this.nextToken().equals("to")) {
                    throw new ParseException("to expected", this.line);
                }
                string = this.nextToken();
                method.addRole(string);
                string = this.nextToken();
                while (string.equals(",")) {
                    string = this.nextToken();
                    method.addRole(string);
                    string = this.nextToken();
                }
            }
            if (!string.equals("public")) {
                throw new ParseException("public expected, found:" + string, this.line);
            }
            string = this.nextToken();
            while (string.equals("authentic") || string.equals("confidential")) {
                if (string.equals("authentic")) {
                    method.setAuthentic();
                } else if (string.equals("confidential")) {
                    method.setConfidential();
                }
                string = this.nextToken();
            }
            method.setType(string);
            method.setName(this.nextToken());
            if (!this.nextToken().equals("(")) {
                throw new ParseException("( expected", this.line);
            }
            string = this.nextToken();
            while (!string.equals(")")) {
                Parameter parameter = new Parameter();
                while (string.equals("authentic") || string.equals("confidential")) {
                    if (string.equals("authentic")) {
                        parameter.setAuthentic();
                    } else if (string.equals("confidential")) {
                        parameter.setConfidential();
                    }
                    string = this.nextToken();
                }
                parameter.setType(string);
                parameter.setName(this.nextToken());
                method.addParameter(parameter);
                string = this.nextToken();
                if (string.equals(",")) {
                    string = this.nextToken();
                    continue;
                }
                if (string.equals(")")) continue;
                throw new ParseException(") expected", this.line);
            }
            string = this.nextToken();
            if (string.equals("throws")) {
                method.addException(this.nextToken());
                string = this.nextToken();
                while (!string.equals(";")) {
                    method.addException(this.nextToken());
                    string = this.nextToken();
                }
            }
            if (!string.equals(";")) {
                throw new ParseException("semicolon expected", this.line);
            }
            string = this.nextToken();
            this.methods.add(method);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String nextToken() {
        this.skipWhiteSpace();
        if (this.parseIndex == this.strippedFromComments.length()) {
            return null;
        }
        var1_1 = new StringBuffer();
        var2_2 = true;
        var3_3 = this.strippedFromComments.charAt(this.parseIndex);
        if (var3_3 == ';' || var3_3 == '(' || var3_3 == ')' || var3_3 == '{' || var3_3 == '}' || var3_3 == ',') {
            ++this.parseIndex;
            return "" + var3_3;
        }
        if (var3_3 != '\"') ** GOTO lbl21
        var4_4 = this.strippedFromComments.indexOf("\"", this.parseIndex + 1) + 1;
        var5_5 = this.strippedFromComments.substring(this.parseIndex, var4_4);
        this.parseIndex = var4_4;
        return var5_5;
lbl-1000:
        // 1 sources

        {
            if ((var3_3 = this.strippedFromComments.charAt(this.parseIndex++)) == ' ' || var3_3 == '\t' || var3_3 == '\n' || var3_3 == '(' || var3_3 == ')' || var3_3 == '{' || var3_3 == '}' || var3_3 == ';' || var3_3 == ',') {
                --this.parseIndex;
                var2_2 = false;
                continue;
            }
            var1_1.append(var3_3);
lbl21:
            // 3 sources

            ** while (this.parseIndex < this.strippedFromComments.length() && var2_2)
        }
lbl22:
        // 1 sources

        return var1_1.toString();
    }

    private void skipWhiteSpace() {
        boolean bl = false;
        while (!bl && this.parseIndex < this.strippedFromComments.length()) {
            char c = this.strippedFromComments.charAt(this.parseIndex);
            if (c == '\n') {
                ++this.line;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                ++this.parseIndex;
                continue;
            }
            bl = true;
        }
    }

    private void stripComments() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.contents.length()) {
            char c = this.contents.charAt(n);
            block0 : switch (c) {
                case '/': {
                    if (n >= this.contents.length() - 1) break;
                    char c2 = this.contents.charAt(n + 1);
                    switch (c2) {
                        case '/': {
                            bl2 = true;
                            ++n;
                            break block0;
                        }
                        case '*': {
                            bl = true;
                            ++n;
                            break block0;
                        }
                    }
                    if (bl || bl2) break;
                    stringBuffer.append(c);
                    break;
                }
                case '*': {
                    if (n >= this.contents.length() - 1) break;
                    if (this.contents.charAt(n + 1) == '/') {
                        bl = false;
                        ++n;
                        break;
                    }
                    if (bl || bl2) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\n': {
                    bl2 = false;
                    if (bl) break;
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    if (bl || bl2) break;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        this.strippedFromComments = stringBuffer.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String[] getRoles() {
        if (this.roles == null) {
            return null;
        }
        String[] stringArray = new String[this.roles.size()];
        this.roles.toArray(stringArray);
        return stringArray;
    }

    public Method[] getMethods() {
        if (this.methods == null) {
            return null;
        }
        Method[] methodArray = new Method[this.methods.size()];
        this.methods.toArray(methodArray);
        return methodArray;
    }

    public String[] getImports() {
        if (this.imports == null) {
            return null;
        }
        String[] stringArray = new String[this.imports.size()];
        this.imports.toArray(stringArray);
        return stringArray;
    }

    public static String removeQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String readString(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }
}

