/*
 * Decompiled with CFR 0.152.
 */
package jason.server;

import jason.Constants;
import jason.server.KeyStore;
import javacard.framework.APDU;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.framework.service.BasicService;
import javacard.security.CryptoException;
import javacard.security.DESKey;
import javacard.security.Key;
import javacard.security.KeyBuilder;
import javacard.security.RandomData;
import javacard.security.Signature;
import javacard.security.XORKey;
import javacard.security.XORPrivateKey;
import javacard.security.XORPublicKey;
import javacardx.crypto.Cipher;

public class Session
extends BasicService
implements Constants {
    public static final byte INS_INVOKE = 56;
    public static final byte INS_LOGIN = 57;
    public static final byte INS_PUT_KEY = 64;
    public static final byte ROLE_CARD = 0;
    private RandomData randomData;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte role;
    private boolean failure;
    private KeyStore keyStore;
    private Cipher cipher;
    private Signature signature;
    private XORKey sessionKey;
    private byte[] jdf;
    private short methodOffset;
    private boolean isInvoking;
    private boolean isLoggingIn;

    public Session(KeyStore keyStore, byte[] jdf) {
        this.keyStore = keyStore;
        this.jdf = jdf;
        this.isInvoking = false;
        this.isLoggingIn = false;
        this.randomData = RandomData.getInstance((byte)2);
        this.clientRandom = new byte[8];
        this.serverRandom = new byte[8];
    }

    public boolean processDataIn(APDU apdu) {
        this.failure = false;
        if (this.getINS(apdu) == 56) {
            this.isInvoking = true;
            return this.decrypt(apdu);
        }
        this.isInvoking = false;
        return false;
    }

    public boolean processCommand(APDU apdu) {
        if (this.failure) {
            return true;
        }
        switch (this.getINS(apdu)) {
            case 57: {
                return this.login(apdu);
            }
            case 64: {
                return this.putKey(apdu);
            }
        }
        return false;
    }

    private boolean login(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        if (!this.isLoggingIn) {
            short offset;
            this.signature = Signature.getInstance((byte)0, false);
            this.isLoggingIn = true;
            apdu.setIncomingAndReceive();
            this.role = buffer[5];
            Util.arrayCopy((byte[])buffer, (short)7, (byte[])this.clientRandom, (short)0, (short)8);
            this.isInvoking = false;
            apdu.setOutgoing();
            this.setOutputLength(apdu, (short)18);
            this.randomData.setSeed(this.clientRandom, (short)0, (short)8);
            this.randomData.generateData(this.serverRandom, (short)0, (short)8);
            short s = offset = 5;
            offset = (short)(offset + 1);
            buffer[s] = (byte)this.serverRandom.length;
            Util.arrayCopy((byte[])this.serverRandom, (short)0, (byte[])buffer, (short)offset, (short)((short)this.serverRandom.length));
            short s2 = offset = (short)(offset + (short)this.serverRandom.length);
            offset = (short)(offset + 1);
            buffer[s2] = 8;
            XORPrivateKey key = (XORPrivateKey)this.keyStore.getKey((byte)0);
            this.signature.init(key, (byte)1);
            this.signature.sign(this.clientRandom, (short)0, (short)8, buffer, offset);
            return this.succeed(apdu);
        }
        this.isLoggingIn = false;
        apdu.setIncomingAndReceive();
        short length = buffer[5];
        if (length > 0) {
            this.signature.init(this.keyStore.getKey(this.role), (byte)2);
            apdu.setOutgoing();
            buffer[5] = this.role;
            if (this.signature.verify(this.serverRandom, (short)0, (short)8, buffer, (short)6, (short)8)) {
                buffer[6] = 1;
                buffer[7] = 8;
                byte[] sessionKeyData = JCSystem.makeTransientByteArray((short)8, (byte)1);
                this.randomData.generateData(sessionKeyData, (short)0, (short)8);
                this.sessionKey = new XORKey();
                this.sessionKey.setKey(sessionKeyData, (short)0);
                this.setOutputLength(apdu, (short)11);
                this.cipher = Cipher.getInstance((byte)0, false);
                this.cipher.init(this.keyStore.getKey(this.role), (byte)1);
                this.cipher.doFinal(sessionKeyData, (short)0, (short)8, buffer, (short)8);
                this.cipher.init(this.sessionKey, (byte)1);
            } else {
                this.setOutputLength(apdu, (short)2);
                buffer[6] = 2;
            }
        } else {
            apdu.setOutgoing();
            this.setOutputLength(apdu, (short)2);
            buffer[5] = this.role;
            buffer[6] = 0;
        }
        JCSystem.requestObjectDeletion();
        return this.succeed(apdu);
    }

    private boolean putKey(APDU apdu) {
        short offset;
        this.isInvoking = false;
        byte[] buffer = apdu.getBuffer();
        short length = apdu.setIncomingAndReceive();
        short s = offset = 5;
        offset = (short)(offset + 1);
        byte role = buffer[s];
        short s2 = offset;
        offset = (short)(offset + 1);
        byte sessionAlgorithm = buffer[s2];
        short s3 = offset;
        offset = (short)(offset + 1);
        byte keyType = buffer[s3];
        short s4 = offset;
        offset = (short)(offset + 1);
        byte keyLength = buffer[s4];
        try {
            Key key;
            switch (keyType) {
                case 3: {
                    key = KeyBuilder.buildKey(keyType, (short)(keyLength * 8), false);
                    ((DESKey)key).setKey(buffer, offset);
                    break;
                }
                case -120: {
                    key = new XORPrivateKey(buffer, offset, keyLength);
                    break;
                }
                case -119: {
                    key = new XORPublicKey(buffer, offset, keyLength);
                    break;
                }
                default: {
                    key = null;
                }
            }
            if (this.keyStore.setKey(role, key, sessionAlgorithm)) {
                this.setOutputLength(apdu, (short)0);
                return this.succeed(apdu);
            }
            this.failure = true;
            return this.fail(apdu, (short)27010);
        }
        catch (CryptoException e) {
            this.failure = true;
            return this.fail(apdu, (short)27010);
        }
    }

    private boolean decrypt(APDU apdu) {
        if (this.role != 0) {
            int jdfOffset;
            int offset;
            byte[] buffer = apdu.getBuffer();
            apdu.setIncomingAndReceive();
            int n = offset = 9;
            offset = (byte)(offset + 1);
            byte lengthPlain = buffer[n];
            int offsetPlain = offset;
            int n2 = offset = (int)((byte)(offset + lengthPlain));
            offset = (byte)(offset + 1);
            byte lengthConfidential = buffer[n2];
            int offsetConfidential = offset;
            int n3 = offset = (int)((byte)(offset + lengthConfidential));
            offset = (byte)(offset + 1);
            byte lengthAuthentic = buffer[n3];
            int offsetAuthentic = offset;
            int n4 = offset = (int)((byte)(offset + lengthAuthentic));
            offset = (byte)(offset + 1);
            byte freshnessCounter = buffer[n4];
            int n5 = offset;
            offset = (byte)(offset + 1);
            byte lengthSignature = buffer[n5];
            int offsetSignature = offset;
            byte[] plainBuffer = JCSystem.makeTransientByteArray((short)lengthPlain, (byte)1);
            if (lengthPlain > 0) {
                Util.arrayCopy((byte[])buffer, (short)((short)offsetPlain), (byte[])plainBuffer, (short)0, (short)lengthPlain);
            }
            byte[] decryptedConfidential = JCSystem.makeTransientByteArray((short)lengthConfidential, (byte)1);
            short lengthDecryptedConfidential = 0;
            if (lengthConfidential > 0) {
                lengthDecryptedConfidential = this.cipher.doFinal(buffer, (short)offsetConfidential, lengthConfidential, decryptedConfidential, (short)0);
            }
            byte[] authenticBuffer = JCSystem.makeTransientByteArray((short)lengthAuthentic, (byte)1);
            if (lengthAuthentic > 0) {
                Util.arrayCopy((byte[])buffer, (short)((short)offsetAuthentic), (byte[])authenticBuffer, (short)0, (short)lengthAuthentic);
            }
            byte[] signatureBuffer = JCSystem.makeTransientByteArray((short)lengthSignature, (byte)1);
            if (lengthSignature > 0) {
                Util.arrayCopy((byte[])buffer, (short)((short)offsetSignature), (byte[])signatureBuffer, (short)0, (short)lengthSignature);
            }
            int n6 = jdfOffset = 0;
            jdfOffset = (short)(jdfOffset + 1);
            short numberOfMethods = this.jdf[n6];
            boolean signaturePresent = false;
            short i = 0;
            while (i < numberOfMethods) {
                if (this.jdf[jdfOffset] != buffer[7] || this.jdf[(short)(jdfOffset + 1)] != buffer[8]) {
                    jdfOffset = (short)(jdfOffset + 2);
                    jdfOffset = (short)(jdfOffset + (this.jdf[jdfOffset] + 2));
                    jdfOffset = (short)(jdfOffset + (this.jdf[jdfOffset] + 1));
                } else {
                    this.methodOffset = (short)jdfOffset;
                    int n7 = jdfOffset = (int)((short)(jdfOffset + 2));
                    jdfOffset = (short)(jdfOffset + 1);
                    short numberOfRoles = this.jdf[n7];
                    boolean loggedIn = numberOfRoles == 0;
                    signaturePresent = numberOfRoles != 0;
                    short j = 0;
                    while (j < numberOfRoles) {
                        loggedIn |= this.jdf[jdfOffset] == this.role | this.jdf[jdfOffset] == 0;
                        int n8 = jdfOffset;
                        jdfOffset = (short)(jdfOffset + 1);
                        signaturePresent &= this.jdf[n8] != 0;
                        j = (short)(j + 1);
                    }
                    int n9 = jdfOffset;
                    jdfOffset = (short)(jdfOffset + 1);
                    byte methodModifier = this.jdf[n9];
                    int n10 = jdfOffset;
                    jdfOffset = (short)(jdfOffset + 1);
                    short numberOfParameters = this.jdf[n10];
                    short plainOffset = 0;
                    short authenticOffset = 0;
                    short confidentialOffset = 0;
                    signaturePresent |= (methodModifier & 0x20) == 32;
                    short j2 = 0;
                    while (j2 < numberOfParameters) {
                        signaturePresent |= (this.jdf[(short)(jdfOffset + j2)] & 0x20) == 32;
                        j2 = (short)(j2 + 1);
                    }
                    if (signaturePresent) {
                        this.signature.update(buffer, (short)7, (short)2);
                        if ((byte)(this.keyStore.freshnessCounters[this.role] + 1) != freshnessCounter) {
                            this.failure = true;
                            return this.fail(apdu, (short)27010);
                        }
                        byte by = this.role;
                        this.keyStore.freshnessCounters[by] = (byte)(this.keyStore.freshnessCounters[by] + 1);
                        this.signature.update(this.keyStore.freshnessCounters, this.role, (short)1);
                    }
                    short dataOffset = 9;
                    short j3 = 0;
                    while (j3 < numberOfParameters) {
                        signaturePresent |= (this.jdf[(short)(jdfOffset + j3)] & 0x20) == 32;
                        short dataLength = 0;
                        switch ((byte)(this.jdf[(short)(jdfOffset + j3)] & 7)) {
                            case 1: 
                            case 2: {
                                dataLength = 1;
                                break;
                            }
                            case 3: {
                                dataLength = 2;
                                break;
                            }
                            case 4: {
                                dataLength = 4;
                                break;
                            }
                            default: {
                                dataLength = 0;
                            }
                        }
                        switch ((byte)(this.jdf[(short)(jdfOffset + j3)] & 0xFFFFFFF0)) {
                            case 0: {
                                if ((byte)(this.jdf[(short)(jdfOffset + j3)] & 8) == 8) {
                                    dataLength = (short)(dataLength * plainBuffer[plainOffset] + 1);
                                }
                                Util.arrayCopy((byte[])plainBuffer, (short)plainOffset, (byte[])buffer, (short)dataOffset, (short)dataLength);
                                plainOffset = (short)(plainOffset + dataLength);
                                break;
                            }
                            case 48: {
                                if ((byte)(this.jdf[(short)(jdfOffset + j3)] & 8) == 8) {
                                    dataLength = (short)(dataLength * decryptedConfidential[confidentialOffset] + 1);
                                }
                                Util.arrayCopy((byte[])decryptedConfidential, (short)confidentialOffset, (byte[])buffer, (short)dataOffset, (short)dataLength);
                                this.signature.update(decryptedConfidential, confidentialOffset, dataLength);
                                confidentialOffset = (short)(confidentialOffset + dataLength);
                                break;
                            }
                            case 16: {
                                if ((byte)(this.jdf[(short)(jdfOffset + j3)] & 8) == 8) {
                                    dataLength = (short)(dataLength * decryptedConfidential[confidentialOffset] + 1);
                                }
                                Util.arrayCopy((byte[])decryptedConfidential, (short)confidentialOffset, (byte[])buffer, (short)dataOffset, (short)dataLength);
                                confidentialOffset = (short)(confidentialOffset + dataLength);
                                break;
                            }
                            case 32: {
                                if ((byte)(this.jdf[(short)(jdfOffset + j3)] & 8) == 8) {
                                    dataLength = (short)(dataLength * authenticBuffer[authenticOffset] + 1);
                                }
                                Util.arrayCopy((byte[])authenticBuffer, (short)authenticOffset, (byte[])buffer, (short)dataOffset, (short)dataLength);
                                this.signature.update(authenticBuffer, authenticOffset, dataLength);
                                authenticOffset = (short)(authenticOffset + dataLength);
                            }
                        }
                        dataOffset = (short)(dataOffset + dataLength);
                        j3 = (short)(j3 + 1);
                    }
                    jdfOffset = (short)(jdfOffset + numberOfParameters);
                }
                i = (short)(i + 1);
            }
            if (signaturePresent && !this.signature.verify(null, (short)0, (short)0, signatureBuffer, (short)0, lengthSignature)) {
                this.failure = true;
                return this.fail(apdu, (short)27010);
            }
            buffer[4] = (byte)(4 + lengthPlain + lengthDecryptedConfidential + lengthAuthentic);
        }
        JCSystem.requestObjectDeletion();
        return false;
    }

    private boolean encrypt(APDU apdu) {
        short dataLength;
        byte[] buffer = apdu.getBuffer();
        short jdfOffset = (short)(this.methodOffset + 2);
        jdfOffset = (short)(jdfOffset + (short)(this.jdf[jdfOffset] + 1));
        byte returnModifier = this.jdf[jdfOffset];
        switch ((byte)(returnModifier & 7)) {
            case 1: 
            case 2: {
                dataLength = 1;
                break;
            }
            case 3: {
                dataLength = 2;
                break;
            }
            case 4: {
                dataLength = 4;
                break;
            }
            default: {
                dataLength = 0;
            }
        }
        boolean isArray = false;
        if ((byte)(returnModifier & 8) != 0) {
            dataLength = (short)(dataLength * buffer[6] + 1);
            isArray = true;
        }
        byte[] unencrypted = JCSystem.makeTransientByteArray((short)dataLength, (byte)1);
        Util.arrayCopy((byte[])buffer, (short)6, (byte[])unencrypted, (short)0, (short)dataLength);
        short outputOffset = 6;
        switch ((byte)(returnModifier & 0xF0)) {
            case 0: {
                outputOffset = (short)(outputOffset + dataLength);
                break;
            }
            case 16: {
                this.cipher.init(this.sessionKey, (byte)1);
                outputOffset = (short)(outputOffset + this.cipher.doFinal(unencrypted, (short)0, dataLength, buffer, outputOffset));
                break;
            }
            case 48: {
                this.cipher.init(this.sessionKey, (byte)1);
                this.signature.init(this.keyStore.getKey((byte)0), (byte)1);
                short confidentialLength = this.cipher.doFinal(unencrypted, (short)0, dataLength, buffer, (short)(outputOffset + 1));
                buffer[outputOffset] = (byte)confidentialLength;
                outputOffset = (short)(outputOffset + (short)(confidentialLength + 1));
                byte by = this.role;
                this.keyStore.freshnessCounters[by] = (byte)(this.keyStore.freshnessCounters[by] + 1);
                this.signature.update(this.keyStore.freshnessCounters, this.role, (short)1);
                short s = outputOffset;
                outputOffset = (short)(outputOffset + 1);
                buffer[s] = this.keyStore.freshnessCounters[this.role];
                outputOffset = (short)(outputOffset + this.signature.sign(unencrypted, (short)0, dataLength, buffer, outputOffset));
                break;
            }
            case 32: {
                this.signature.init(this.keyStore.getKey((byte)0), (byte)1);
                byte by = this.role;
                this.keyStore.freshnessCounters[by] = (byte)(this.keyStore.freshnessCounters[by] + 1);
                this.signature.update(this.keyStore.freshnessCounters, this.role, (short)1);
                short s = outputOffset = (short)(outputOffset + dataLength);
                outputOffset = (short)(outputOffset + 1);
                buffer[s] = this.keyStore.freshnessCounters[this.role];
                outputOffset = (short)(outputOffset + this.signature.sign(unencrypted, (short)0, dataLength, buffer, outputOffset));
            }
        }
        this.setOutputLength(apdu, (short)(outputOffset - 5));
        JCSystem.requestObjectDeletion();
        return true;
    }

    public boolean processDataOut(APDU apdu) {
        if (this.failure) {
            return true;
        }
        byte[] buffer = apdu.getBuffer();
        if (this.isInvoking & buffer[2] == -112 && buffer[3] == 0 && buffer[5] == -127) {
            return this.encrypt(apdu);
        }
        return false;
    }
}

