/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import javacard.framework.Util;
import javacard.security.Key;

public class XORPrivateKey
implements Key {
    private byte[] key;

    public XORPrivateKey(byte[] privateKey, short offset, short length) {
        this.key = new byte[length];
        Util.arrayCopy((byte[])privateKey, (short)offset, (byte[])this.key, (short)0, (short)length);
    }

    public boolean isInitialized() {
        return true;
    }

    public void clearKey() {
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = 0;
            i = (short)(i + 1);
        }
    }

    public byte getType() {
        return -120;
    }

    public short getSize() {
        return (short)(8 * this.key.length);
    }

    public byte[] getEncoded() {
        return this.key;
    }

    public void getEncoded(byte[] output, short offset) {
        short i = 0;
        while (i < (short)this.key.length) {
            output[(short)(i + offset)] = this.key[i];
            i = (short)(i + 1);
        }
    }
}

