/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import jason.client.XORKey;
import jason.client.XORPrivateKey;
import jason.client.XORPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.Enumeration;
import java.util.Hashtable;

public class KeyStore
implements Serializable {
    protected static final String[] algorithmNames = new String[]{"DES"};
    protected static final byte[] algorithmValues = new byte[]{3};
    protected Hashtable keys = new Hashtable();
    protected Hashtable sessionAlgorithms = new Hashtable();
    protected Hashtable freshnessCounters = new Hashtable();

    public Key getKey(byte by) {
        return (Key)this.keys.get(new Byte(by));
    }

    public void setKey(byte by, Key key, String string) {
        this.keys.put(new Byte(by), key);
        this.sessionAlgorithms.put(new Byte(by), string);
    }

    public static byte algorithmNameToValue(String string) {
        int n = 0;
        while (n < algorithmNames.length) {
            if (algorithmNames[n].equals(string)) {
                return algorithmValues[n];
            }
            ++n;
        }
        return -1;
    }

    public static String algorithmValueToName(byte by) {
        int n = 0;
        while (n < algorithmValues.length) {
            if (algorithmValues[n] == by) {
                return algorithmNames[n];
            }
            ++n;
        }
        return null;
    }

    public byte getAlgorithmValue(byte by) {
        return KeyStore.algorithmNameToValue(this.getKey(by).getAlgorithm());
    }

    public String getSessionAlgorithmName(byte by) {
        return (String)this.sessionAlgorithms.get(new Byte(by));
    }

    public byte getSessionAlgorithmValue(byte by) {
        return KeyStore.algorithmNameToValue(this.getSessionAlgorithmName(by));
    }

    public void increaseFreshnessCounter(byte by) {
        this.freshnessCounters.put(new Byte(by), new Byte((byte)(this.getFreshnessCounter(by) + 1)));
    }

    public byte getFreshnessCounter(byte by) {
        Byte by2 = (Byte)this.freshnessCounters.get(new Byte(by));
        if (by2 == null) {
            by2 = new Byte(0);
            this.freshnessCounters.put(new Byte(by), by2);
        }
        return by2;
    }

    public static KeyStore load(InputStream inputStream) throws IOException {
        KeyStore keyStore = null;
        try {
            ObjectInputStream objectInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : new ObjectInputStream(inputStream);
            keyStore = (KeyStore)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return keyStore;
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = outputStream instanceof ObjectOutputStream ? (ObjectOutputStream)outputStream : new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    public void show() {
        Byte by;
        System.out.println("Keys:");
        Enumeration enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            by = (Byte)enumeration.nextElement();
            System.out.print(by + " --> ");
            Key key = (Key)this.keys.get(by);
            if (key instanceof XORKey) {
                System.out.println(KeyStore.arrayToString(((XORKey)key).getEncoded()));
            }
            if (key instanceof XORPrivateKey) {
                System.out.println(KeyStore.arrayToString(((XORPrivateKey)key).getEncoded()));
            }
            if (!(key instanceof XORPublicKey)) continue;
            System.out.println(KeyStore.arrayToString(((XORPublicKey)key).getEncoded()));
        }
        System.out.println("sessionAlgorithms:");
        enumeration = this.sessionAlgorithms.keys();
        while (enumeration.hasMoreElements()) {
            by = (Byte)enumeration.nextElement();
            System.out.println(by + " --> " + this.sessionAlgorithms.get(by));
        }
        System.out.println("freshnessCounters:");
        enumeration = this.freshnessCounters.keys();
        while (enumeration.hasMoreElements()) {
            by = (Byte)enumeration.nextElement();
            System.out.println(by + " --> " + this.freshnessCounters.get(by));
        }
    }

    private static String arrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                String string = Integer.toHexString(byArray[n] & 0xFF);
                if (string.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                stringBuffer.append(' ');
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

