/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import jason.client.XORCipher;
import java.security.AlgorithmParameters;
import java.security.Certificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class MyCipher {
    private XORCipher cipherSpi;
    private Provider provider;
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;

    public MyCipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = (XORCipher)cipherSpi;
        this.provider = provider;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return "XOR";
    }

    public final int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, new SecureRandom());
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, secureRandom);
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, new SecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameters, new SecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameters, secureRandom);
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, new SecureRandom());
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        PublicKey publicKey = certificate.getPublicKey();
        this.cipherSpi.engineInit(n, publicKey, secureRandom);
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        return this.cipherSpi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        return null;
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        return null;
    }
}

