/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import com.sun.javacard.javax.smartcard.rmiclient.CardAccessor;
import com.sun.javacard.javax.smartcard.rmiclient.JavaCardRMIConnect;
import jason.client.KeyStore;
import jason.client.LoginException;
import jason.client.SecureCardAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;

public class Ans {
    protected Properties properties;
    protected KeyStore keyStore;
    protected SecureCardAccessor cardAccessor;
    protected JavaCardRMIConnect javaCardRMIConnect;

    public Ans(KeyStore keyStore) {
        this.properties = new Properties();
        try {
            this.properties.load(ClassLoader.getSystemResourceAsStream("jason/client/ans.properties"));
            this.init(keyStore);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            keyStore = null;
            this.cardAccessor = null;
            this.javaCardRMIConnect = null;
        }
    }

    public Ans(KeyStore keyStore, Properties properties) {
        this.properties = properties;
        this.init(keyStore);
    }

    protected void init(KeyStore keyStore) {
        this.keyStore = keyStore;
        this.cardAccessor = new SecureCardAccessor();
        try {
            this.cardAccessor.setRemote(this.properties.getProperty("host", "localhost"), Integer.parseInt(this.properties.getProperty("port", "8080")));
            System.out.println("RMI connecting....");
            this.javaCardRMIConnect = new JavaCardRMIConnect((CardAccessor)this.cardAccessor);
        }
        catch (RemoteException remoteException) {
            System.out.println("Cannot connect to host");
        }
    }

    public Object getApplet(String string, byte by) throws IOException {
        System.out.println("selectApplet");
        this.javaCardRMIConnect.selectApplet(this.getAppletAID(string));
        if (!this.cardAccessor.login(by, this.keyStore)) {
            System.out.println("Not logged in");
            throw new LoginException("Could not log in as role " + by);
        }
        System.out.println("Logged in");
        System.out.println("\ngetInitialReference");
        return this.javaCardRMIConnect.getInitialReference();
    }

    public void setHost(String string) {
        this.properties.setProperty("host", string);
    }

    public void setPort(int n) {
        this.properties.setProperty("port", Integer.toString(n));
    }

    public void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        inputStream.close();
    }

    public void store(OutputStream outputStream) throws IOException {
        this.properties.store(outputStream, null);
        outputStream.close();
    }

    public void addApplet(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void addApplet(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < byArray.length) {
            if (!bl) {
                stringBuffer.append(':');
                bl = false;
            }
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        this.addApplet(string, stringBuffer.toString());
    }

    public void deleteApplet(String string) {
        ((Hashtable)this.properties).remove(string);
    }

    public byte[] getAppletAID(String string) {
        String string2 = this.properties.getProperty(string);
        int n = 1;
        int n2 = 0;
        while (n2 < string2.length()) {
            n += string2.charAt(n2) == ':' ? 1 : 0;
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            String string3 = n4 == n - 1 ? string2.substring(n3) : string2.substring(n3, string2.indexOf(58, n3));
            byArray[n4] = string3.startsWith("0x") ? (byte)Integer.parseInt(string3.substring(2), 16) : (byte)Integer.parseInt(string3);
            n3 = string2.indexOf(58, n3 + 1) + 1;
            ++n4;
        }
        return byArray;
    }

    static {
        System.loadLibrary("NativeMethods");
    }
}

