/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import jason.client.XORSignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class MySignature {
    private XORSignature sigSpi;

    public MySignature(SignatureSpi signatureSpi) {
        this.sigSpi = (XORSignature)signatureSpi;
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.sigSpi.engineInitVerify(publicKey);
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.sigSpi.engineInitSign(privateKey);
    }

    public void update(byte by) throws SignatureException {
        this.sigSpi.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sigSpi.engineUpdate(byArray, n, n2);
    }

    public byte[] sign() throws SignatureException {
        return this.sigSpi.engineSign();
    }

    public int sign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.sign();
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return byArray2.length;
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return this.sigSpi.engineVerify(byArray);
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.sigSpi.engineSetParameter(string, object);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.sigSpi.engineSetParameter("Parameter", "Value");
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.sigSpi.engineGetParameter(string);
    }
}

