/*
 * Decompiled with CFR 0.152.
 */
package javacardx.crypto;

import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.XORKey;
import javacard.security.XORPrivateKey;
import javacard.security.XORPublicKey;
import javacardx.crypto.Cipher;

public class XORCipher
extends Cipher {
    private byte[] key = new byte[8];
    private short keyIndex;

    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey instanceof XORKey) {
            ((XORKey)theKey).getKey(this.key, (short)0);
        } else if (theKey instanceof XORPrivateKey) {
            ((XORPrivateKey)theKey).getEncoded(this.key, (short)0);
        } else if (theKey instanceof XORPublicKey) {
            ((XORPublicKey)theKey).getEncoded(this.key, (short)0);
        }
        this.keyIndex = 0;
    }

    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        this.init(theKey, theMode);
    }

    public byte getAlgorithm() {
        return 80;
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        return this.update(inBuff, inOffset, inLength, outBuff, outOffset);
    }

    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        short i = inOffset;
        while (i < (short)(inLength + inOffset)) {
            short s = outOffset;
            outOffset = (short)(outOffset + 1);
            outBuff[s] = (byte)(this.key[this.keyIndex] ^ inBuff[i]);
            this.keyIndex = (short)((short)(this.keyIndex + 1) % this.key.length);
            i = (short)(i + 1);
        }
        return inLength;
    }
}

