/*
 * Decompiled with CFR 0.152.
 */
package jason.client;

import com.sun.javacard.javax.smartcard.rmiclient.CardAccessor;
import jason.Constants;
import jason.client.Appender;
import jason.client.CipherAppender;
import jason.client.InvalidFreshnessCounterException;
import jason.client.InvalidSignatureException;
import jason.client.JasonSecurityException;
import jason.client.KeyStore;
import jason.client.LoginException;
import jason.client.MyCipher;
import jason.client.MySignature;
import jason.client.SignatureAppender;
import jason.client.Stub;
import jason.client.XORCipher;
import jason.client.XORKey;
import jason.client.XORPrivateKey;
import jason.client.XORProvider;
import jason.client.XORPublicKey;
import jason.client.XORSignature;
import jason.terminal.RemoteCardAccessor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class SecureCardAccessor
implements CardAccessor,
Constants {
    public static final byte ROLE_CARD = 0;
    private RemoteCardAccessor remoteCardAccessor = null;
    private short id = 0;
    private byte[] jdf;
    private byte role;
    private MyCipher cipher = null;
    private SecureRandom secureRandom = null;
    private MySignature signature = null;
    private KeyStore keyStore;
    private XORKey sessionKey;
    private static byte[] loginData = new byte[]{-128, 57, 2, 2};
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;

    public byte[] exchangeAPDU(byte[] byArray) throws IOException {
        System.out.println("Received from client: " + SecureCardAccessor.arrayToString(byArray));
        byte[] byArray2 = byArray[0] == 0 && byArray[1] == -92 ? this.selectAPDU(byArray) : this.invokeAPDU(byArray);
        System.out.println("Send to client:       " + SecureCardAccessor.arrayToString(byArray2));
        return byArray2;
    }

    public short getSessionIdentifier() {
        return this.id;
    }

    public void setRemote(String string, int n) throws RemoteException {
        try {
            this.remoteCardAccessor = (RemoteCardAccessor)Naming.lookup("//" + string + ":" + n + "/RemoteCardAccessor");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RemoteException(malformedURLException.getMessage());
        }
        catch (NotBoundException notBoundException) {
            throw new RemoteException(notBoundException.getMessage());
        }
    }

    public boolean login(byte by, KeyStore keyStore) throws IOException {
        this.keyStore = keyStore;
        this.role = by;
        System.out.println("Logging in as role " + by + "...");
        try {
            XORPrivateKey xORPrivateKey = (XORPrivateKey)keyStore.getKey(by);
            System.out.println("role private key:     " + SecureCardAccessor.arrayToString(xORPrivateKey.getEncoded()));
            System.out.println("role public key:      " + SecureCardAccessor.arrayToString(new XORPublicKey(xORPrivateKey).getEncoded()));
            if (xORPrivateKey == null) {
                return false;
            }
            if (this.secureRandom == null) {
                System.out.println("Initializing SecureRandom...");
                this.secureRandom = new SecureRandom();
            }
            byte[] byArray = new byte[8];
            this.secureRandom.nextBytes(byArray);
            byte[] byArray2 = new byte[loginData.length + 4 + byArray.length];
            System.arraycopy(loginData, 0, byArray2, 0, loginData.length);
            int n = loginData.length;
            byArray2[n++] = (byte)(byArray.length + 2);
            byArray2[n++] = by;
            byArray2[n++] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
            byArray2[n += byArray.length] = 127;
            System.out.println("Send to client:       " + SecureCardAccessor.arrayToString(byArray2));
            byte[] byArray3 = this.remoteCardAccessor.exchangeAPDU(byArray2);
            System.out.println("Received from client: " + SecureCardAccessor.arrayToString(byArray3));
            n = 2;
            byte by2 = byArray3[n++];
            byte[] byArray4 = new byte[by2];
            System.arraycopy(byArray3, n, byArray4, 0, by2);
            n += by2;
            byte by3 = byArray3[n++];
            XORPublicKey xORPublicKey = (XORPublicKey)keyStore.getKey((byte)0);
            System.out.println("card public key:      " + SecureCardAccessor.arrayToString(xORPublicKey.getEncoded()));
            this.signature = new MySignature(new XORSignature());
            this.signature.initVerify(xORPublicKey);
            this.signature.update(byArray3, n, by3);
            if (this.signature.verify(byArray)) {
                this.signature.initSign(xORPrivateKey);
                this.signature.update(byArray4, 0, byArray4.length);
                byte[] byArray5 = this.signature.sign();
                byArray2 = new byte[7 + byArray5.length];
                n = 0;
                byArray2[n++] = -128;
                byArray2[n++] = 57;
                byArray2[n++] = 2;
                byArray2[n++] = 2;
                byArray2[n++] = (byte)(byArray5.length + 1);
                byArray2[n++] = (byte)byArray5.length;
                System.arraycopy(byArray5, 0, byArray2, n, byArray5.length);
                n += byArray5.length;
                byArray2[n++] = 127;
                System.out.println("Send to client:       " + SecureCardAccessor.arrayToString(byArray2));
                byArray3 = this.remoteCardAccessor.exchangeAPDU(byArray2);
                System.out.println("Received from client: " + SecureCardAccessor.arrayToString(byArray3));
                System.out.println("Client random:           " + SecureCardAccessor.arrayToString(byArray));
                System.out.println("Server random:           " + SecureCardAccessor.arrayToString(byArray4));
                System.out.println("Encrypted server random: " + SecureCardAccessor.arrayToString(byArray5));
                if (byArray3[0] == -112 && byArray3[1] == 0 && byArray3[2] == by && byArray3[3] == 1) {
                    this.cipher = new MyCipher(new XORCipher(), new XORProvider(), "XOR");
                    this.cipher.init(2, new XORPublicKey(xORPrivateKey));
                    byte[] byArray6 = this.cipher.doFinal(byArray3, 5, byArray3[4]);
                    this.sessionKey = new XORKey(byArray6);
                    this.cipher.init(1, this.sessionKey);
                    System.out.println("Session key:           " + SecureCardAccessor.arrayToString(byArray6));
                    return true;
                }
                return false;
            }
            byte[] byArray7 = new byte[by3];
            System.arraycopy(byArray3, n, byArray7, 0, by3);
            System.out.println("Invalid signature");
            throw new InvalidSignatureException("Invalid signature");
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        this.remoteCardAccessor.exchangeAPDU(new byte[]{-128, 57, 2, 2, 0, 127});
        return false;
    }

    public boolean putKey(byte by, byte by2, Key key, byte by3) throws IOException {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = new byte[byArray.length + 10];
        int n = 0;
        byArray2[n++] = -128;
        byArray2[n++] = 64;
        byArray2[n++] = 2;
        byArray2[n++] = 2;
        byArray2[n++] = (byte)(4 + byArray.length);
        byArray2[n++] = by;
        byArray2[n++] = by3;
        byArray2[n++] = by2;
        byArray2[n++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        n += byArray.length;
        byArray2[n++] = 127;
        byte[] byArray3 = this.remoteCardAccessor.exchangeAPDU(byArray2);
        return byArray3 != null && byArray3.length >= 2 && byArray3[0] == -112 && byArray3[1] == 0;
    }

    private byte[] selectAPDU(byte[] byArray) throws IOException {
        byte[] byArray2 = this.remoteCardAccessor.exchangeAPDU(byArray);
        System.out.println("Received from card:   " + SecureCardAccessor.arrayToString(byArray2));
        if (byArray2[2] == 111 && byArray2[4] == 110 && byArray2[6] == 94 && byArray2[11] == -127) {
            String string;
            String string2;
            this.id = (short)((byArray2[12] >> 8 | byArray2[13]) & 0xFFFF);
            int n = 15 + byArray2[14];
            byte by = byArray2[n++];
            try {
                string2 = new String(byArray2, n, (int)by, "UTF-8").replace('/', '.');
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = "";
            }
            n += by;
            by = byArray2[n++];
            try {
                string = new String(byArray2, n, (int)by, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = "";
            }
            String string3 = string2 + "." + string;
            System.out.println("Select " + string3);
            n += by;
            try {
                Class<?> clazz = Class.forName(string3 + "_Stub");
                Constructor<?> constructor = clazz.getConstructor(class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = SecureCardAccessor.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef);
                Stub stub = (Stub)constructor.newInstance(new Object[]{null});
                this.jdf = stub.getJDF();
                System.out.println("jdf = " + SecureCardAccessor.arrayToString(this.jdf));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.jdf = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.jdf = null;
            }
            catch (InstantiationException instantiationException) {
                this.jdf = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.jdf = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.jdf = null;
            }
        }
        return byArray2;
    }

    private byte[] invokeAPDU(byte[] byArray) throws IOException {
        int n = 0;
        int n2 = this.jdf[n++];
        int n3 = 0;
        while (n3 < n2) {
            if (this.jdf[n] != byArray[7] || this.jdf[n + 1] != byArray[8]) {
                n += 2;
                n += this.jdf[n] + 2;
                n += this.jdf[n] + 1;
            } else {
                int n4;
                n += 2;
                boolean bl = (n4 = this.jdf[n++]) == 0;
                boolean bl2 = n4 != 0;
                int n5 = 0;
                while (n5 < n4) {
                    bl |= this.jdf[n] == this.role | this.jdf[n] == 0;
                    bl2 &= this.jdf[n++] != 0;
                    ++n5;
                }
                if (!bl) {
                    throw new LoginException("You are not correctly logged in");
                }
                byte by = this.jdf[n++];
                int n6 = this.jdf[n++];
                Appender appender = new Appender(false);
                Appender appender2 = new Appender(false);
                CipherAppender cipherAppender = new CipherAppender(this.cipher, false);
                SignatureAppender signatureAppender = new SignatureAppender(this.signature, false);
                bl2 |= (by & 0x20) == 32;
                int n7 = 9;
                byte by2 = 0;
                int n8 = 0;
                while (n8 < n6) {
                    bl2 |= (this.jdf[n + n8] & 0x20) == 32;
                    ++n8;
                }
                if (bl2) {
                    signatureAppender.append(byArray, 7, 2);
                    this.keyStore.increaseFreshnessCounter(this.role);
                    by2 = this.keyStore.getFreshnessCounter(this.role);
                    signatureAppender.append(by2);
                }
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = 0;
                    switch (this.jdf[n + n9] & 7) {
                        case 1: 
                        case 2: {
                            n10 = 1;
                            break;
                        }
                        case 3: {
                            n10 = 2;
                            break;
                        }
                        case 4: {
                            n10 = 4;
                            break;
                        }
                        default: {
                            n10 = 0;
                        }
                    }
                    if ((this.jdf[n + n9] & 8) == 8) {
                        n10 = n10 * byArray[n7] + 1;
                    }
                    switch (this.jdf[n + n9] & 0xF0) {
                        case 0: {
                            appender.append(byArray, n7, n10);
                            break;
                        }
                        case 48: {
                            signatureAppender.append(byArray, n7, n10);
                        }
                        case 16: {
                            cipherAppender.append(byArray, n7, n10);
                            break;
                        }
                        case 32: {
                            appender2.append(byArray, n7, n10);
                            signatureAppender.append(byArray, n7, n10);
                        }
                    }
                    n7 += n10;
                    ++n9;
                }
                byte[] byArray2 = appender.getBuffer();
                byte[] byArray3 = cipherAppender.getBuffer();
                byte[] byArray4 = appender2.getBuffer();
                byte[] byArray5 = signatureAppender.getBuffer();
                Appender appender3 = new Appender(false);
                appender3.append(byArray, 0, 9);
                appender3.append((byte)byArray2.length);
                appender3.append(byArray2);
                appender3.append((byte)byArray3.length);
                appender3.append(byArray3);
                appender3.append((byte)byArray4.length);
                appender3.append(byArray4);
                appender3.append(by2);
                if (bl2) {
                    appender3.append((byte)byArray5.length);
                    appender3.append(byArray5);
                } else {
                    appender3.append((byte)0);
                }
                appender3.append((byte)127);
                byte[] byArray6 = appender3.getBuffer();
                byArray6[4] = (byte)(9 + byArray2.length + byArray3.length + byArray4.length);
                if (bl2) {
                    byArray6[4] = (byte)(byArray6[4] + byArray5.length);
                }
                System.out.println("Send to card:         " + SecureCardAccessor.arrayToString(byArray6));
                byte[] byArray7 = null;
                try {
                    int n11;
                    byte[] byArray8 = null;
                    byte[] byArray9 = this.remoteCardAccessor.exchangeAPDU(byArray6);
                    System.out.println("Received from card:   " + SecureCardAccessor.arrayToString(byArray9));
                    if (byArray9[0] == 105 && byArray9[1] == -126) {
                        throw new JasonSecurityException("For security reasons the card does not accept the command");
                    }
                    if (byArray9[0] != -112 || byArray9[1] != 0) {
                        throw new RemoteException("Card error, SW = 0x" + Integer.toHexString((byArray9[0] & 0xFF) << 8 | byArray9[1] & 0xFF));
                    }
                    if (byArray9[2] != -127) {
                        return byArray9;
                    }
                    switch ((byte)(by & 7)) {
                        case 1: 
                        case 2: {
                            n11 = 1;
                            break;
                        }
                        case 3: {
                            n11 = 2;
                            break;
                        }
                        case 4: {
                            n11 = 4;
                            break;
                        }
                        default: {
                            n11 = 0;
                        }
                    }
                    boolean bl3 = (by & 8) == 8;
                    switch ((byte)(by & 0xF0)) {
                        case 0: {
                            if (bl3) {
                                n11 = n11 * byArray9[3] + 1;
                            }
                            byArray8 = new byte[n11];
                            System.arraycopy(byArray9, 3, byArray8, 0, n11);
                            break;
                        }
                        case 16: {
                            this.cipher.init(2, this.sessionKey);
                            byArray8 = this.cipher.doFinal(byArray9, 3, byArray9.length - 3);
                            break;
                        }
                        case 48: {
                            this.cipher.init(2, this.sessionKey);
                            byte by3 = byArray9[3];
                            int n12 = byArray9.length - by3 - 5;
                            byArray8 = this.cipher.doFinal(byArray9, 4, by3);
                            try {
                                this.signature.initVerify((PublicKey)this.keyStore.getKey((byte)0));
                                by2 = byArray9[4 + by3];
                                this.checkFreshnessCounter(by2);
                                this.signature.update(by2);
                                this.signature.update(byArray8, 0, byArray8.length);
                                byte[] byArray10 = new byte[n12];
                                System.arraycopy(byArray9, 5 + by3, byArray10, 0, n12);
                                if (this.signature.verify(byArray10)) break;
                                throw new InvalidSignatureException("Signature of response data is invalid");
                            }
                            catch (SignatureException signatureException) {
                                System.out.println("Signature could not be checked");
                                signatureException.printStackTrace();
                            }
                            break;
                        }
                        case 32: {
                            if (bl3) {
                                n11 = n11 * byArray9[3] + 1;
                            }
                            byArray8 = new byte[n11];
                            System.arraycopy(byArray9, 3, byArray8, 0, n11);
                            try {
                                this.signature.initVerify((PublicKey)this.keyStore.getKey((byte)0));
                                by2 = byArray9[3 + n11];
                                this.checkFreshnessCounter(by2);
                                this.signature.update(by2);
                                this.signature.update(byArray8, 0, n11);
                                byte[] byArray11 = new byte[byArray9.length - 4 - n11];
                                System.arraycopy(byArray9, 4 + n11, byArray11, 0, byArray11.length);
                                if (this.signature.verify(byArray11)) break;
                                throw new InvalidSignatureException("Signature of response data is invalid");
                            }
                            catch (SignatureException signatureException) {
                                throw new InvalidSignatureException("Signature could not be checked");
                            }
                        }
                    }
                    byArray7 = new byte[3 + byArray8.length];
                    System.arraycopy(byArray9, 0, byArray7, 0, 3);
                    System.arraycopy(byArray8, 0, byArray7, 3, byArray8.length);
                }
                catch (BadPaddingException badPaddingException) {
                    badPaddingException.printStackTrace();
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                }
                return byArray7;
            }
            ++n3;
        }
        System.out.println("Method not found");
        return null;
    }

    private void checkFreshnessCounter(byte by) throws InvalidFreshnessCounterException {
        if (this.keyStore.getFreshnessCounter(this.role) + 1 != by) {
            throw new InvalidFreshnessCounterException("FreshnessCounter " + by + " found, but " + (this.keyStore.getFreshnessCounter(this.role) + 1) + " is expected.");
        }
        this.keyStore.increaseFreshnessCounter(this.role);
    }

    private static String arrayToString(byte[] byArray) {
        return SecureCardAccessor.arrayToString(byArray, 0, byArray.length);
    }

    private static String arrayToString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                String string = Integer.toHexString(byArray[n3] & 0xFF);
                if (string.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                stringBuffer.append(' ');
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

