/*
 * Decompiled with CFR 0.152.
 */
package jason.compiler;

import jason.Constants;
import jason.compiler.Method;
import jason.compiler.Parameter;
import jason.compiler.Parser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import sun.rmi.rmic.IndentingWriter;

public class Main
implements Constants {
    File jasonFile;
    File packageDir;
    File cardDir;
    File pcDir;
    File interfaceFile;
    File stubFile;
    File skeletonFile;
    Parser parser;

    public void makeInterface() throws IOException {
        int n;
        String[] stringArray;
        String[] stringArray2 = this.parser.getRoles();
        Method[] methodArray = this.parser.getMethods();
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.interfaceFile));
        String string = this.parser.getPackageName();
        if (string != null) {
            printWriter.println("package " + string + ";");
            printWriter.println();
        }
        if ((stringArray = this.parser.getImports()) != null) {
            n = 0;
            while (n < stringArray.length) {
                printWriter.println("import " + stringArray[n] + ";");
                ++n;
            }
        }
        printWriter.println("import java.rmi.Remote;");
        if (methodArray.length > 0) {
            printWriter.println("import java.rmi.RemoteException;");
        }
        printWriter.println();
        printWriter.println("public interface " + this.parser.getInterfaceName() + " extends Remote {");
        printWriter.println("\tpublic static final byte ROLE_ANYBODY = (byte) 0;");
        n = 0;
        while (n < stringArray2.length) {
            printWriter.println("\tpublic static final byte ROLE_" + stringArray2[n].toUpperCase() + " = (byte) " + Integer.toString(n + 1) + ";");
            ++n;
        }
        printWriter.println();
        int n2 = 0;
        while (n2 < methodArray.length) {
            printWriter.print("\tpublic " + methodArray[n2].getType() + " " + methodArray[n2].getName() + "(");
            Parameter[] parameterArray = methodArray[n2].getParameters();
            boolean bl = true;
            int n3 = 0;
            while (n3 < parameterArray.length) {
                if (!bl) {
                    printWriter.print(", ");
                }
                printWriter.print(parameterArray[n3].getType() + " " + parameterArray[n3].getName());
                bl = false;
                ++n3;
            }
            printWriter.print(")");
            printWriter.print(" throws RemoteException");
            String[] stringArray3 = methodArray[n2].getExceptions();
            if (stringArray3 != null && stringArray3.length > 0) {
                int n4 = 0;
                while (n4 < stringArray3.length) {
                    printWriter.print(", " + stringArray3[n4]);
                    ++n4;
                }
            }
            printWriter.println(";");
            ++n2;
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void makeStub() throws IOException {
        int n;
        int n2;
        Method[] methodArray = this.parser.getMethods();
        IndentingWriter indentingWriter = new IndentingWriter((Writer)new FileWriter(this.stubFile), 2);
        indentingWriter.pln("// Stub class generated by jason.compiler.Main, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        String string = this.parser.getPackageName();
        String string2 = this.parser.getInterfaceName();
        if (string != null) {
            indentingWriter.pln("package " + string + ";");
            indentingWriter.pln();
        }
        indentingWriter.pln("import jason.client.Stub;");
        indentingWriter.pln("import java.lang.reflect.Method;");
        indentingWriter.pln("import java.rmi.Remote;");
        indentingWriter.pln("import java.rmi.RemoteException;");
        indentingWriter.pln("import java.rmi.UnexpectedException;");
        indentingWriter.pln("import java.rmi.server.RemoteRef;");
        indentingWriter.pln("import java.rmi.server.RemoteStub;");
        String[] stringArray = this.parser.getImports();
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                indentingWriter.pln("import " + stringArray[n2] + ";");
                ++n2;
            }
        }
        indentingWriter.pln("import java.rmi.Remote;");
        if (methodArray.length > 0) {
            indentingWriter.pln("import java.rmi.RemoteException;");
        }
        indentingWriter.pln();
        indentingWriter.plnI("public final class " + string2 + "Impl_Stub");
        indentingWriter.pln("extends RemoteStub");
        indentingWriter.pln("implements " + string + "." + string2 + ", Remote, Stub {");
        indentingWriter.pln();
        indentingWriter.pln("private static final long serialVersionUID = 2;");
        indentingWriter.pln();
        n2 = 0;
        while (n2 < methodArray.length) {
            indentingWriter.pln("private static Method $method_" + methodArray[n2].getName() + "_" + n2 + ";");
            ++n2;
        }
        indentingWriter.pln();
        indentingWriter.plnI("static {");
        indentingWriter.plnI("try {");
        int n3 = 0;
        while (n3 < methodArray.length) {
            indentingWriter.p("$method_" + methodArray[n3].getName() + "_" + n3 + " = " + string + "." + string2 + ".class.getMethod(\"" + methodArray[n3].getName() + "\", new java.lang.Class[] {");
            Parameter[] parameterArray = methodArray[n3].getParameters();
            boolean bl = true;
            n = 0;
            while (n < parameterArray.length) {
                indentingWriter.p((bl ? "" : ", ") + parameterArray[n].getType() + ".class");
                bl = false;
                ++n;
            }
            indentingWriter.pln("});");
            ++n3;
        }
        indentingWriter.pOln("}");
        indentingWriter.plnI("catch (NoSuchMethodException e) {");
        indentingWriter.pln("throw new NoSuchMethodError(\"stub class initialization failed\");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.pln("// constructors");
        indentingWriter.plnI("public " + string2 + "Impl_Stub" + "(RemoteRef ref) {");
        indentingWriter.pln("super(ref);");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        int n4 = 0;
        while (n4 < methodArray.length) {
            String string3;
            indentingWriter.p("// implementation of " + methodArray[n4].getName() + "(");
            Parameter[] parameterArray = methodArray[n4].getParameters();
            n = 1;
            int n5 = 0;
            while (n5 < parameterArray.length) {
                indentingWriter.p((n != 0 ? "" : ", ") + parameterArray[n5].getType());
                n = 0;
                ++n5;
            }
            indentingWriter.pln(")");
            indentingWriter.p("public " + methodArray[n4].getType() + " " + methodArray[n4].getName() + "(");
            n = 1;
            int n6 = 0;
            while (n6 < parameterArray.length) {
                indentingWriter.p((n != 0 ? "" : ", ") + parameterArray[n6].getType() + " param" + n6);
                n = 0;
                ++n6;
            }
            indentingWriter.pln(")");
            indentingWriter.p("throws RemoteException");
            String[] stringArray2 = methodArray[n4].getExceptions();
            int n7 = 0;
            while (n7 < stringArray2.length) {
                indentingWriter.p(", " + stringArray2[n7]);
                ++n7;
            }
            indentingWriter.plnI(" {");
            indentingWriter.plnI("try {");
            if (!methodArray[n4].getType().equals("void")) {
                indentingWriter.p("Object result = ");
            }
            indentingWriter.p("ref.invoke(this, $method_" + methodArray[n4].getName() + "_" + n4 + ", new Object[] {");
            n = 1;
            int n8 = 0;
            while (n8 < parameterArray.length) {
                if (n == 0) {
                    indentingWriter.p(", ");
                } else {
                    n = 0;
                }
                string3 = parameterArray[n8].getType();
                if (string3.equals("byte")) {
                    indentingWriter.p("new Byte(param" + n8 + ")");
                } else if (string3.equals("boolean")) {
                    indentingWriter.p("new Boolean(param" + n8 + ")");
                } else if (string3.equals("short")) {
                    indentingWriter.p("new Short(param" + n8 + ")");
                } else {
                    indentingWriter.p("param" + n8);
                }
                ++n8;
            }
            indentingWriter.pln("}, 0L);");
            string3 = methodArray[n4].getType();
            if (!string3.equals("void")) {
                if (string3.equals("byte")) {
                    indentingWriter.pln("return ((Byte) result).byteValue();");
                } else if (string3.equals("boolean")) {
                    indentingWriter.pln("return ((Boolean) result).booleanValue();");
                } else if (string3.equals("short")) {
                    indentingWriter.pln("return ((Short) result).shortValue();");
                } else {
                    indentingWriter.pln("return (" + string3 + ") result;");
                }
            }
            indentingWriter.pOln("}");
            indentingWriter.plnI("catch (RuntimeException rte) {");
            indentingWriter.pln("throw rte;");
            indentingWriter.pOln("}");
            indentingWriter.plnI("catch (RemoteException re) {");
            indentingWriter.pln("throw re;");
            indentingWriter.pOln("}");
            int n9 = 0;
            while (n9 < stringArray2.length) {
                indentingWriter.plnI("catch (" + stringArray2[n9] + " e" + n9 + ") {");
                indentingWriter.pln("throw e" + n9 + ";");
                indentingWriter.pOln("}");
                ++n9;
            }
            indentingWriter.plnI("catch (Exception e) {");
            indentingWriter.pln("throw new UnexpectedException(\"undeclared checked exception\", e);");
            indentingWriter.pOln("}");
            indentingWriter.pOln("}");
            indentingWriter.pln();
            ++n4;
        }
        this.writeJDFArray(indentingWriter);
        indentingWriter.plnI("public byte[] getJDF() {");
        indentingWriter.pln("return JDF;");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.close();
    }

    public void makeSkeleton() throws IOException {
        Method[] methodArray = this.parser.getMethods();
        String[] stringArray = this.parser.getRoles();
        String string = this.parser.getPackageName();
        String string2 = this.parser.getInterfaceName();
        IndentingWriter indentingWriter = new IndentingWriter((Writer)new FileWriter(this.skeletonFile), 2);
        indentingWriter.pln("// Skeleton class generated by jason.compiler.Main, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (string != null) {
            indentingWriter.pln("package " + string + ";");
            indentingWriter.pln();
        }
        indentingWriter.pln("import jason.server.*;");
        indentingWriter.pln("import javacard.framework.*;");
        indentingWriter.pln("import javacard.framework.service.Dispatcher;");
        indentingWriter.pln("import javacard.framework.service.RMIService;");
        indentingWriter.pln();
        indentingWriter.plnI("public class " + string2 + "_Skel extends Applet {");
        indentingWriter.pln("private Dispatcher dispatcher;");
        this.writeJDFArray(indentingWriter);
        indentingWriter.plnI("public " + string2 + "_Skel() {");
        indentingWriter.pln("dispatcher = new Dispatcher((short) 4);");
        indentingWriter.pln(string2 + " " + string2.toLowerCase() + " = new " + string2 + "Impl();");
        indentingWriter.pln("Session session = new Session(new KeyStore((short) " + Integer.toString(stringArray.length + 1) + "), JDF);");
        indentingWriter.pln("dispatcher.addService(session, Dispatcher.PROCESS_INPUT_DATA);");
        indentingWriter.pln("dispatcher.addService(session, Dispatcher.PROCESS_COMMAND);");
        indentingWriter.pln("RMIService rmiService = new RMIService(" + string2.toLowerCase() + ");");
        indentingWriter.pln("dispatcher.addService(rmiService, Dispatcher.PROCESS_COMMAND);");
        indentingWriter.pln("dispatcher.addService(session, Dispatcher.PROCESS_OUTPUT_DATA);");
        indentingWriter.pln("register();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public static void install(byte[] buffer, short offset, byte length) {");
        indentingWriter.pln("new " + string2 + "_Skel();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public boolean select() {");
        indentingWriter.pln("return true;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void process(APDU apdu) throws ISOException {");
        indentingWriter.pln("dispatcher.process(apdu);");
        indentingWriter.pln("JCSystem.requestObjectDeletion();");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.close();
    }

    public void writeJDFArray(IndentingWriter indentingWriter) throws IOException {
        String[] stringArray = this.parser.getRoles();
        Method[] methodArray = this.parser.getMethods();
        indentingWriter.p("private static final byte[] JDF = {");
        indentingWriter.p("(byte) 0x" + Integer.toHexString(methodArray.length));
        int n = 0;
        while (n < methodArray.length) {
            short s = Main.computeShortHash(methodArray[n].getName() + this.getDescriptor(methodArray[n]));
            indentingWriter.p(", (byte) 0x" + Integer.toHexString(s >> 8 & 0xFF));
            indentingWriter.p(", (byte) 0x" + Integer.toHexString(s & 0xFF));
            String[] stringArray2 = methodArray[n].getRoles();
            indentingWriter.p(", (byte) 0x" + Integer.toHexString(stringArray2.length));
            int n2 = 0;
            while (n2 < stringArray2.length) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray2[n2].equals(stringArray[n3])) {
                        indentingWriter.p(", (byte) 0x" + Integer.toHexString(n3 + 1));
                    }
                    ++n3;
                }
                ++n2;
            }
            int n4 = this.typeToValue(methodArray[n].getType());
            n4 |= methodArray[n].isConfidential() ? 16 : 0;
            indentingWriter.p(", (byte) 0x" + Integer.toHexString(n4 |= methodArray[n].isAuthentic() ? 32 : 0));
            Parameter[] parameterArray = methodArray[n].getParameters();
            indentingWriter.p(", (byte) 0x" + Integer.toHexString(parameterArray.length));
            int n5 = 0;
            while (n5 < parameterArray.length) {
                n4 = this.typeToValue(parameterArray[n5].getType());
                n4 |= parameterArray[n5].isConfidential() ? 16 : 0;
                indentingWriter.p(", (byte) 0x" + Integer.toHexString(n4 |= parameterArray[n5].isAuthentic() ? 32 : 0));
                ++n5;
            }
            ++n;
        }
        indentingWriter.pln("};");
        indentingWriter.pln();
    }

    public void makeOldStub() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.stubFile));
        String string = this.parser.getPackageName();
        if (string != null) {
            printWriter.println("package " + string + ".terminal;");
            printWriter.println();
        }
        printWriter.println("import java.io.IOException;");
        printWriter.println("import jason.framework.terminal.Stub;");
        printWriter.println("import jason.security.card.KeyStore;");
        printWriter.println("import " + string + ".card." + this.parser.getInterfaceName() + ";");
        printWriter.println();
        printWriter.println("public class " + this.parser.getInterfaceName() + "Stub extends Stub implements " + this.parser.getInterfaceName() + " {");
        printWriter.println("\tpublic " + this.parser.getInterfaceName() + "Stub(String hostname, int port, KeyStore keyStore) throws IOException {");
        printWriter.println("\t\tconnect(hostname, port, keyStore);");
        printWriter.println("\t}");
        printWriter.println();
        Method[] methodArray = this.parser.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            int n2;
            printWriter.print("\tpublic " + methodArray[n].getType() + " " + methodArray[n].getName() + "(");
            Parameter[] parameterArray = methodArray[n].getParameters();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n3 = 0;
            while (n3 < parameterArray.length) {
                bl2 |= !parameterArray[n3].isConfidential() && !parameterArray[n3].isAuthentic();
                bl3 |= parameterArray[n3].isConfidential() && !parameterArray[n3].isAuthentic();
                bl4 |= parameterArray[n3].isAuthentic() && !parameterArray[n3].isConfidential();
                bl5 |= parameterArray[n3].isConfidential() && parameterArray[n3].isAuthentic();
                if (!bl) {
                    printWriter.print(", ");
                }
                printWriter.print(parameterArray[n3].getType() + " " + parameterArray[n3].getName());
                bl = false;
                ++n3;
            }
            printWriter.println(") {");
            String[] stringArray = methodArray[n].getRoles();
            boolean bl6 = false;
            int n4 = 0;
            while (n4 < stringArray.length) {
                bl6 |= stringArray[n4].equals("ANYBODY");
                ++n4;
            }
            if (!bl6) {
                bl = true;
                n2 = 0;
                while (n2 < stringArray.length) {
                    if (bl) {
                        printWriter.print("\t\tif (");
                        bl = false;
                    } else {
                        printWriter.print(" && \n\t\t    ");
                    }
                    printWriter.print("session.getActiveRole() != " + stringArray[n2].toUpperCase());
                    ++n2;
                }
                printWriter.println(") ");
                bl = true;
                int n5 = 0;
                while (n5 < stringArray.length) {
                    if (bl) {
                        printWriter.print("\t\t\tsession.logIn(new byte[] {");
                        bl = false;
                    } else {
                        printWriter.print(", ");
                    }
                    printWriter.print(stringArray[n5].toUpperCase());
                    ++n5;
                }
                printWriter.println("});");
            }
            printWriter.println("\t\tsession.write(" + methodArray[n].getName().toUpperCase() + ");");
            if (bl2) {
                printWriter.println("\t\tsession.setMode(Session.MODE_SEND_PLAIN);");
                n2 = 0;
                while (n2 < parameterArray.length) {
                    if (!parameterArray[n2].isConfidential() && !parameterArray[n2].isAuthentic()) {
                        printWriter.println("\t\tsession.write(" + parameterArray[n2].getName() + ");");
                    }
                    ++n2;
                }
            }
            if (bl3) {
                printWriter.println("\t\tsession.setMode(Session.MODE_SEND_CONFIDENTIAL);");
                n2 = 0;
                while (n2 < parameterArray.length) {
                    if (parameterArray[n2].isConfidential() && !parameterArray[n2].isAuthentic()) {
                        printWriter.println("\t\tsession.write(" + parameterArray[n2].getName() + ");");
                    }
                    ++n2;
                }
            }
            if (bl5) {
                printWriter.println("\t\tsession.setMode(Session.MODE_SEND_CONFIDENTIAL_AUTHENTIC);");
                n2 = 0;
                while (n2 < parameterArray.length) {
                    if (parameterArray[n2].isConfidential() && parameterArray[n2].isAuthentic()) {
                        printWriter.println("\t\tsession.write(" + parameterArray[n2].getName() + ");");
                    }
                    ++n2;
                }
            }
            if (bl4) {
                printWriter.println("\t\tsession.setMode(Session.MODE_SEND_AUTHENTIC);");
                n2 = 0;
                while (n2 < parameterArray.length) {
                    if (!parameterArray[n2].isConfidential() && parameterArray[n2].isAuthentic()) {
                        printWriter.println("\t\tsession.write(" + parameterArray[n2].getName() + ");");
                    }
                    ++n2;
                }
            }
            if (!methodArray[n].isConfidential() && !methodArray[n].isAuthentic()) {
                printWriter.println("\t\tsession.setMode(Session.MODE_RECEIVE_PLAIN);");
            } else if (methodArray[n].isConfidential() && !methodArray[n].isAuthentic()) {
                printWriter.println("\t\tsession.setMode(Session.MODE_RECEIVE_CONFIDENTIAL);");
            } else if (methodArray[n].isConfidential() && methodArray[n].isAuthentic()) {
                printWriter.println("\t\tsession.setMode(Session.MODE_RECEIVE_CONFIDENTIAL_AUTHENTIC);");
            } else if (!methodArray[n].isConfidential() && methodArray[n].isAuthentic()) {
                printWriter.println("\t\tsession.setMode(Session.MODE_RECEIVE_AUTHENTIC);");
            }
            printWriter.println("\t\tbyte exception=session.readByte();");
            printWriter.println("\t\t//Handel hier de exception af");
            if (methodArray[n].getType().equals("byte")) {
                printWriter.println("\t\treturn session.readByte();");
            } else if (methodArray[n].getType().equals("boolean")) {
                printWriter.println("\t\treturn session.readBoolean();");
            } else if (methodArray[n].getType().equals("short")) {
                printWriter.println("\t\treturn session.readShort();");
            } else if (methodArray[n].getType().equals("byte[]")) {
                printWriter.println("\t\treturn session.readByteArray();");
            }
            printWriter.println("\t}");
            printWriter.println();
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void makeOldSkeleton() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.skeletonFile));
        String string = this.parser.getPackageName();
        if (string != null) {
            printWriter.println("package " + string + ".card;");
            printWriter.println();
        }
        printWriter.println("import jason.framework.card.Gateway;");
        printWriter.println("import jason.security.card.KeyStore;");
        printWriter.println("import jason.security.card.Session;");
        printWriter.println("import javacard.framework.*;");
        printWriter.println();
        printWriter.println("public class " + this.parser.getInterfaceName() + "Skeleton extends Applet implements Gateway {");
        printWriter.println("\tprivate byte[] incomingBytes;");
        printWriter.println("\tprivate byte[] outgoingBytes;");
        printWriter.println("\tprivate " + this.parser.getInterfaceName() + " " + this.parser.getInterfaceName().toLowerCase() + ";");
        printWriter.println("\tprivate KeyStore keystore;");
        printWriter.println("\tprivate Session session;");
        printWriter.println();
        printWriter.println("\tprivate " + this.parser.getInterfaceName() + "Skeleton() {");
        printWriter.println("\t\t" + this.parser.getInterfaceName().toLowerCase() + " = new " + this.parser.getInterfaceName() + "Impl();");
        String[] stringArray = this.parser.getRoles();
        printWriter.println("\t\tkeystore = new KeyStore((byte) " + stringArray.length + ");");
        printWriter.println("\t\tsession = new Session(keystore);");
        printWriter.println("\t\tregister();");
        printWriter.println("\t}");
        printWriter.println();
        Method[] methodArray = this.parser.getMethods();
        printWriter.println("\tpublic void process() throws ISOException {");
        printWriter.println("\t\tsession.unmarshall(incomingBytes, (short) 0, (short) (incomingBytes.length));");
        printWriter.println("\t\tswitch (incomingBytes[0]) {");
        int n = 0;
        while (n < methodArray.length) {
            int n2;
            boolean bl;
            int n3;
            printWriter.println("\t\t\tcase " + this.parser.getInterfaceName() + "." + methodArray[n].getName().toUpperCase() + ": {");
            String[] stringArray2 = methodArray[n].getRoles();
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < stringArray2.length) {
                bl2 |= stringArray2[n4].equals("ANYBODY");
                ++n4;
            }
            if (!bl2) {
                printWriter.print("\t\t\t\tif (session.getActiveRole() != ");
                boolean bl3 = true;
                n3 = 0;
                while (n3 < stringArray2.length) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        printWriter.print(" && \n\t\t\t\t    session.getActiveRole() != ");
                    }
                    printWriter.print(this.parser.getInterfaceName() + "." + stringArray2[n3].toUpperCase());
                    ++n3;
                }
                printWriter.println(")");
                printWriter.println("\t\t\t\t\tISOException.throwIt(ISO7816.SW_SECURITY_STATUS_NOT_SATISFIED);");
            }
            Parameter[] parameterArray = methodArray[n].getParameters();
            n3 = 0;
            while (n3 < 4) {
                boolean bl4 = n3 == 1 || n3 == 2;
                bl = n3 == 2 || n3 == 3;
                n2 = 0;
                while (n2 < parameterArray.length) {
                    if (parameterArray[n2].isConfidential() == bl4 && parameterArray[n2].isAuthentic() == bl) {
                        printWriter.print("\t\t" + parameterArray[n2].getType() + " " + parameterArray[n2].getName() + " = ");
                        if (parameterArray[n2].getType().equals("byte")) {
                            printWriter.println("session.readByte();");
                        } else if (parameterArray[n2].getType().equals("boolean")) {
                            printWriter.println("session.readBoolean();");
                        } else if (parameterArray[n2].getType().equals("short")) {
                            printWriter.println("session.readShort();");
                        } else if (parameterArray[n2].getType().equals("byte[]")) {
                            printWriter.println("JCSystem.makeTransientByteArray(session.readByteArrayLength(), JCSystem.CLEAR_ON_RESET);");
                            printWriter.println("\t\tsession.readByteArray(" + parameterArray[n2].getName() + ", (short) 0);");
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
            if (!methodArray[n].getType().equals("void")) {
                printWriter.println("\t\t\t\t" + methodArray[n].getType() + " result;");
            }
            printWriter.println("\t\t\t\tbyte exception = (byte) 0;");
            String[] stringArray3 = methodArray[n].getExceptions();
            if (stringArray3 != null && stringArray3.length > 0) {
                printWriter.println("\t\t\t\ttry {");
                printWriter.print("\t");
            }
            printWriter.print("\t\t\t\t");
            if (!methodArray[n].getType().equals("void")) {
                printWriter.print("result = ");
            }
            printWriter.print(this.parser.getInterfaceName().toLowerCase() + "." + methodArray[n].getName() + "(");
            bl = true;
            n2 = 0;
            while (n2 < parameterArray.length) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(", ");
                }
                printWriter.print(parameterArray[n2].getName());
                ++n2;
            }
            printWriter.println(");");
            String string2 = methodArray[n].getType();
            if (string2.equals("byte[]")) {
                printWriter.println("\t\t\t\\ttoutgoingBytes = JCSystem.makeTransientByteArray((short) (result.length+1), JCSystem.CLEAR_ON_RESET);");
                printWriter.println("\t\t\t\t\tUtil.arrayCopy(result, (short) 0, outgoingBytes, (short) 1, (short) result.length);");
            } else if (string2.equals("byte")) {
                printWriter.println("\t\t\t\t\toutgoingBytes = JCSystem.makeTransientByteArray((short) 2, JCSystem.CLEAR_ON_RESET);");
                printWriter.println("\t\t\t\t\toutgoingBytes[1] = result;");
            } else if (string2.equals("short")) {
                printWriter.println("\t\t\t\t\toutgoingBytes = JCSystem.makeTransientByteArray((short) 3, JCSystem.CLEAR_ON_RESET);");
                printWriter.println("\t\t\t\t\tUtil.setShort(outgoingBytes, (short) 1, result);");
            } else if (string2.equals("boolean")) {
                printWriter.println("\t\t\t\t\toutgoingBytes = JCSystem.makeTransientByteArray((short) 2, JCSystem.CLEAR_ON_RESET);");
                printWriter.println("\t\t\t\t\toutgoingBytes[1] = (boolean) result;");
            } else if (string2.equals("void")) {
                printWriter.println("\t\t\t\t\toutgoingBytes = JCSystem.makeTransientByteArray((short) 1, JCSystem.CLEAR_ON_RESET);");
            }
            if (stringArray3 != null && stringArray3.length > 0) {
                printWriter.println("\t\t\t\t}");
                int n5 = 0;
                while (n5 < stringArray3.length) {
                    printWriter.println("\t\t\t\tcatch (" + stringArray3[n5] + " e" + Integer.toString(n5 + 1) + ") { exception = " + Integer.toString(n5 + 1) + "; }");
                    ++n5;
                }
            }
            printWriter.println("\t\t\t\toutgoingBytes[0] = exception;");
            printWriter.println("\t\t\t\tbreak;");
            printWriter.println("\t\t\t}");
            ++n;
        }
        printWriter.println("\t\t}");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {");
        printWriter.println("\t\tnew " + this.parser.getInterfaceName() + "Skeleton();");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic void process(APDU apdu) {");
        printWriter.println("\t\tISOException.throwIt(ISO7816.SW_APPLET_SELECT_FAILED); //This applet should not be selected directly");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic void setIncomingSize(short size) {");
        printWriter.println("\t\tincomingBytes = JCSystem.makeTransientByteArray(size, JCSystem.CLEAR_ON_RESET);");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic short getOutgoingSize() {");
        printWriter.println("\t\treturn outgoingBytes==null ? (short) 0 : (short) outgoingBytes.length;");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic void putByte(short index, byte value) {");
        printWriter.println("\t\tincomingBytes[index] = value;");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic byte getByte(short index) {");
        printWriter.println("\t\treturn outgoingBytes[index];");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.println("\tpublic Shareable getShareableInterfaceObject(AID clientAID, byte parameter) {");
        printWriter.println("\t\treturn parameter==1 ? (Shareable) session : (Shareable) this;");
        printWriter.println("\t}");
        printWriter.println("}");
        printWriter.close();
    }

    public Main(String[] stringArray) throws IOException {
        String string = stringArray[stringArray.length - 1];
        if (!string.toLowerCase().endsWith(".jason")) {
            throw new IOException(string + " is not a .jason file");
        }
        this.parser = new Parser(new File(string));
        try {
            this.parser.parse();
        }
        catch (ParseException parseException) {
            System.out.println("ParseException at " + parseException.getErrorOffset() + ": " + parseException.getMessage());
        }
        this.jasonFile = new File(string);
        String string2 = this.jasonFile.getName().substring(0, this.jasonFile.getName().indexOf(".jason"));
        this.packageDir = new File(this.jasonFile.getParent());
        this.interfaceFile = new File(this.packageDir, string2 + ".java");
        this.stubFile = new File(this.packageDir, string2 + "Impl_Stub.java");
        this.skeletonFile = new File(this.packageDir, string2 + "_Skel.java");
        this.makeInterface();
        this.makeStub();
        this.makeSkeleton();
    }

    private static final short computeShortHash(String string) {
        int n = 0;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = messageDigest.digest(byArray);
            n = byArray2.length >= 2 ? (int)((short)(byArray2[0] << 8 | byArray2[1] & 0xFF)) : -1;
        }
        catch (IOException iOException) {
            n = -1;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return (short)n;
    }

    private String getDescriptor(Method method) {
        String string;
        Parameter[] parameterArray = method.getParameters();
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < parameterArray.length) {
            string = parameterArray[n].getType();
            if (string.endsWith("[]")) {
                string = string.substring(0, string.length() - 2);
                stringBuffer.append("[");
            }
            if ("boolean".equals(string)) {
                stringBuffer.append("Z");
            } else if ("byte".equals(string)) {
                stringBuffer.append("B");
            } else if ("short".equals(string)) {
                stringBuffer.append("S");
            } else if ("int".equals(string)) {
                stringBuffer.append("I");
            } else {
                stringBuffer.append(string);
            }
            ++n;
        }
        stringBuffer.append(")");
        string = method.getType();
        if (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            stringBuffer.append("[");
        }
        if ("boolean".equals(string)) {
            stringBuffer.append("Z");
        } else if ("byte".equals(string)) {
            stringBuffer.append("B");
        } else if ("short".equals(string)) {
            stringBuffer.append("S");
        } else if ("int".equals(string)) {
            stringBuffer.append("I");
        } else if ("void".equals(string)) {
            stringBuffer.append("V");
        } else if ("[Z".equals(string)) {
            stringBuffer.append("[Z");
        } else if ("[B".equals(string)) {
            stringBuffer.append("[B");
        } else if ("[S".equals(string)) {
            stringBuffer.append("[S");
        } else if ("[I".equals(string)) {
            stringBuffer.append("[I");
        } else {
            stringBuffer.append("L");
            stringBuffer.append(string.replace('.', '/'));
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public int typeToValue(String string) {
        int n = string.startsWith("byte") ? 1 : (string.startsWith("boolean") ? 2 : (string.startsWith("short") ? 3 : (string.startsWith("int") ? 4 : (string.startsWith("void") ? 0 : 5))));
        if (string.endsWith("[]")) {
            n |= 8;
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0 || stringArray[stringArray.length - 1].substring(0, 1).equals("-")) {
            System.out.println("Syntax: java jason.compiler.Main [options] <jasonfile>");
            System.out.println("where options are not yet implemented");
        } else {
            Main main = new Main(stringArray);
        }
    }
}

