package jason.client;

import java.security.Signature;
import java.security.SignatureException;

public class SignatureAppender extends Appender {
	protected MySignature signature;

	public SignatureAppender(MySignature signature) {
		this(signature, true);
	}

	public SignatureAppender(MySignature signature, boolean storeLengths) {
		super(storeLengths);
		this.signature = signature;
	}

	protected void appendIntern(byte[] b, int offset, int length) {
		try {
			if (signature != null)
				signature.update(b, offset, length);
		}
		catch (SignatureException e) {
			//Do something
		}
	}

	public byte[] getBuffer() {
		try {
			if (signature != null)
				return signature.sign();
			else
				return new byte[0];
		}
		catch (SignatureException e) {
			return null;
		}
	}
}