package jason.client;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

/**
 * <p>Title: Javacards As Secure Object Store</p>
 * <p>Description: CipherAppender adds security to the normal {@link Appender}</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University of Twente</p>
 * @author Richard Brinkman
 * @version 1.0
 */
public class CipherAppender extends Appender {
	/**
	 * 	MyCipher is used only to simulate. In the real version this should be
	 *  {@link javax.crypto.Cipher}.
	 */
  protected MyCipher cipher;

	/**
	 * @param cipher The cipher to be used. It should already been initialized.
	 */
  public CipherAppender(MyCipher cipher) {
    this(cipher, true);
  }

	/**
	 * @param cipher The cipher to be used. It should already been initialized.
	 * @param storeLengths Indicate whether the length of an array should be stored as well
	 */
	public CipherAppender(MyCipher cipher, boolean storeLengths) {
		super(storeLengths);
		this.cipher = cipher;
	}

	/**
	 * Encrypts the specified part of the byte array and appends it to the
	 * internal buffer.
	 * @param b Data to be appended
	 * @param offset Offset within <code>b</code>
	 * @param length Length of the bytes to be copied
	 */
  protected void appendIntern(byte[] b, int offset, int length) {
		if (cipher == null)
			super.appendIntern(b, offset, length);
		else {
			byte[] encrypted = cipher.update(b, offset, length);
			super.appendIntern(encrypted, 0, encrypted.length);
		}
  }

	/**
	 * Encrypts the last pending bytes and returns the cipher text. After a call
	 * to <code>getBuffer</code> no more bytes should be added to it.
	 * @return The cipher text
	 */
  public byte[] getBuffer() {
    try {
			if (cipher != null)
	      super.appendIntern(cipher.doFinal());
    }
    catch (IllegalBlockSizeException e) {
      return null;
    }
    catch (BadPaddingException e) {
      return null;
    }
    return buffer;
  }
}
