package jason.client;

import java.security.*;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.*;

/**
 * <p>Title: Javacards As Secure Object Network</p>
 * <p>Description: My own Cipher object used only within simulator</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University of Twente</p>
 * @author Richard Brinkman
 * @version 1.0
 */
public class MyCipher {
	private XORCipher cipherSpi;
	private Provider provider;

	public MyCipher(CipherSpi cipherSpi, Provider provider, String transformation) {
		this.cipherSpi = (XORCipher) cipherSpi;
		this.provider = provider;
	}

	public final Provider getProvider()	{
		return provider;
	}

	public final String getAlgorithm() {
		return "XOR";
	}

	public final int getBlockSize()
	{
		return cipherSpi.engineGetBlockSize();
	}

	public final int getOutputSize(int inputSize) throws IllegalStateException {
			return cipherSpi.engineGetOutputSize(inputSize);
	}

	public final byte[] getIV()	{
		return cipherSpi.engineGetIV();
	}

	public final AlgorithmParameters getParameters() {
		return cipherSpi.engineGetParameters();
	}

	public final ExemptionMechanism getExemptionMechanism()
	{
		return null;
	}

	public final void init(int i1, Key key)	throws InvalidKeyException {
		cipherSpi.engineInit(i1, key, new SecureRandom());
	}

	public final void init(int i1, Key key, SecureRandom securerandom) throws InvalidKeyException	{
		cipherSpi.engineInit(i1, key, securerandom);
	}

	public final void init(int i1, Key key, AlgorithmParameterSpec algorithmparameterspec) throws InvalidKeyException, InvalidAlgorithmParameterException {
		cipherSpi.engineInit(i1, key, algorithmparameterspec, new SecureRandom());
	}

	public final void init(int i1, Key key, AlgorithmParameterSpec algorithmparameterspec, SecureRandom securerandom)
		throws InvalidKeyException, InvalidAlgorithmParameterException {
		cipherSpi.engineInit(i1, key, algorithmparameterspec, securerandom);
	}

	public final void init(int i1, Key key, AlgorithmParameters algorithmparameters)
		throws InvalidKeyException, InvalidAlgorithmParameterException {
		cipherSpi.engineInit(i1, key, algorithmparameters, new SecureRandom());
	}

	public final void init(int i1, Key key, AlgorithmParameters algorithmparameters, SecureRandom securerandom)
		throws InvalidKeyException, InvalidAlgorithmParameterException {
		cipherSpi.engineInit(i1, key, algorithmparameters, securerandom);
	}

	public final void init(int i1, Certificate certificate)	throws InvalidKeyException {
		init(i1, certificate, new SecureRandom());
	}

	public final void init(int i1, Certificate certificate, SecureRandom securerandom)
		throws InvalidKeyException {
		java.security.PublicKey publickey = certificate.getPublicKey();
		cipherSpi.engineInit(i1, publickey, securerandom);
	}

	public final byte[] update(byte abyte0[])	throws IllegalStateException {
		return cipherSpi.engineUpdate(abyte0, 0, abyte0.length);
	}

	public final byte[] update(byte abyte0[], int i1, int j1)	throws IllegalStateException {
		return cipherSpi.engineUpdate(abyte0, i1, j1);
	}

	public final int update(byte abyte0[], int i1, int j1, byte abyte1[]) throws IllegalStateException, ShortBufferException {
		return cipherSpi.engineUpdate(abyte0, i1, j1, abyte1, 0);
	}

	public final int update(byte abyte0[], int i1, int j1, byte abyte1[], int k1)
		throws IllegalStateException, ShortBufferException {
		return cipherSpi.engineUpdate(abyte0, i1, j1, abyte1, k1);
	}

	public final byte[] doFinal()
		throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		return cipherSpi.engineDoFinal(null, 0, 0);
	}

	public final int doFinal(byte abyte0[], int i1)
		throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
		return cipherSpi.engineDoFinal(null, 0, 0, abyte0, i1);
	}

	public final byte[] doFinal(byte abyte0[])
		throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		return cipherSpi.engineDoFinal(abyte0, 0, abyte0.length);
	}

	public final byte[] doFinal(byte abyte0[], int i1, int j1)
		throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		return cipherSpi.engineDoFinal(abyte0, i1, j1);
	}

	public final int doFinal(byte abyte0[], int i1, int j1, byte abyte1[])
		throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
		return cipherSpi.engineDoFinal(abyte0, i1, j1, abyte1, 0);
	}

	public final int doFinal(byte abyte0[], int i1, int j1, byte abyte1[], int k1)
		throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
		return cipherSpi.engineDoFinal(abyte0, i1, j1, abyte1, k1);
	}

	public final byte[] wrap(Key key)
		throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
		return null;
		//return cipherSpi.engineWrap(key);
	}

	public final Key unwrap(byte abyte0[], String s1, int i1)
		throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException	{
		//return cipherSpi.engineUnwrap(abyte0, s1, i1);
		return null;
	}

	public static final int ENCRYPT_MODE = 1;
	public static final int DECRYPT_MODE = 2;
	public static final int WRAP_MODE = 3;
	public static final int UNWRAP_MODE = 4;
	public static final int PUBLIC_KEY = 1;
	public static final int PRIVATE_KEY = 2;
	public static final int SECRET_KEY = 3;
}