package jason.compiler;

import java.util.Vector;

public class Method extends SecurityObject {
	private Vector parameters;
	private Vector roles;
	private Vector exceptions;

	public Method() {
		parameters = new Vector();
		roles = new Vector();
		exceptions = new Vector();
	}

	public Parameter[] getParameters() {
		Parameter[] result = new Parameter[parameters.size()];
		parameters.toArray(result);
		return result;
	}

	public void addParameter(Parameter parameter) {
		parameters.add(parameter);
	}

	public String[] getRoles() {
		String[] result = new String[roles.size()];
		roles.toArray(result);
		return result;
	}

	public void addRole(String role) {
		roles.add(role);
	}

	public String[] getExceptions() {
		String[] result = new String[exceptions.size()];
		exceptions.toArray(result);
		return result;
	}

	public void addException(String exception) {
		exceptions.add(exception);
	}
}
