package example.purse;

import java.rmi.RemoteException;
import javacard.framework.*;
import javacard.framework.service.CardRemoteObject;

public class PurseImpl extends CardRemoteObject implements Purse {
	public static final short LIMIT = (short) 250;

	public static final short NEGATIVE_VALUE = (short) 1;
	public static final short OVERFLOW = (short) 2;
	public static final short UNDERFLOW = (short) 3;

	private short balance;

	public PurseImpl() {
		super();
		balance = (short) 0;
	}

	public short getBalance() throws RemoteException {
		return balance;
	}

	public void increaseBalance(short amount) throws UserException, RemoteException {
		if (amount < 0)
			UserException.throwIt(NEGATIVE_VALUE);
		if ((short) (amount + amount) > LIMIT)
			UserException.throwIt(OVERFLOW);
		balance += amount;
	}

	public void decreaseBalance(short amount) throws UserException, RemoteException {
		if (amount < 0)
			UserException.throwIt(NEGATIVE_VALUE);
		if ((short) (balance - amount) < 0)
			UserException.throwIt(UNDERFLOW);
		balance -= amount;
	}
}