package jason;

/**
 * <p>Title: Javacards As Secure Object Store</p>
 * <p>Description: Constants used in the {@link jason} package and its
 * subpackages</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University of Twente</p>
 * @author Richard Brinkman
 * @version 1.0
 */
public interface Constants {
	public static final byte TYPE_VOID                       = (byte) 0x00;
	public static final byte TYPE_BYTE                       = (byte) 0x01;
	public static final byte TYPE_BOOLEAN                    = (byte) 0x02;
	public static final byte TYPE_SHORT                      = (byte) 0x03;
	public static final byte TYPE_INT                        = (byte) 0x04;
	public static final byte TYPE_OBJECT                     = (byte) 0x05;
	public static final byte TYPE_ARRAY                      = (byte) 0x08;
	public static final byte TYPE_BYTE_ARRAY                 = (byte) (TYPE_BYTE    | TYPE_ARRAY);
	public static final byte TYPE_BOOLEAN_ARRAY              = (byte) (TYPE_BOOLEAN | TYPE_ARRAY);
	public static final byte TYPE_SHORT_ARRAY                = (byte) (TYPE_SHORT   | TYPE_ARRAY);
	public static final byte TYPE_INT_ARRAY                  = (byte) (TYPE_INT     | TYPE_ARRAY);
	public static final byte TYPE_OBJECT_ARRAY               = (byte) (TYPE_OBJECT  | TYPE_ARRAY);
	public static final byte SECURITY_PLAIN                  = (byte) 0x00;
	public static final byte SECURITY_CONFIDENTIAL           = (byte) 0x10;
	public static final byte SECURITY_AUTHENTIC              = (byte) 0x20;
	public static final byte SECURITY_CONFIDENTIAL_AUTHENTIC = (byte) (SECURITY_CONFIDENTIAL | SECURITY_AUTHENTIC);

	public static final byte JDF_TAG = (byte) 0x7E;
	public static final byte FCI_TAG = (byte) 0x6F;
	public static final byte APPLICATION_DATA_TAG = (byte) 0x6E;
	public static final byte JC_RMI_DATA_TAG = (byte) 0x5E;
	public static final byte NORMAL_TAG = (byte) 0x81;

	public static final byte ANYBODY = (byte) 0x00;
}
