package javacard.security;

import javacard.framework.Util;
import javacard.security.Key;

public class Signature {
	private XORPublicKey key;
	private byte[] signature;
	private byte mode;
	private short offset;
	public static final short SIGNATURE_LENGTH = (short) 8;

	public static final Signature getInstance(byte algorithm, boolean externalAccess)	throws CryptoException {
		return new Signature();
	}

	public void init(Key key, byte mode) throws CryptoException {
		this.mode = mode;
		switch (mode) {
			case MODE_SIGN:
				byte[] privateKey = ((XORPrivateKey) key).getEncoded();
				byte[] publicKey = new byte[(short) (privateKey.length / 2)];
				for (short i=0; i<publicKey.length; i++)
					publicKey[i] = (byte) (privateKey[(short) (i*2)] ^ privateKey[(short) (i*2+1)]);
				this.key = new XORPublicKey(publicKey, (short) 0, (short) publicKey.length);
				break;
			case MODE_VERIFY:
				this.key = (XORPublicKey) key;
		}
		byte[] data = this.key.getEncoded();
		offset = (short) 0;
		for (short i=0; i<SIGNATURE_LENGTH; i++)
			signature[i] = (byte) 0;
		update(data, (short) 0, (short) data.length);
	}

	public void init(Key key, byte mode, byte array[], short offset, short length) throws CryptoException {
		init(key, mode);
	}

	protected Signature()	{
		signature = new byte[SIGNATURE_LENGTH];
		for (short i=0; i<SIGNATURE_LENGTH; i++)
			signature[i] = (byte) 0;
		offset = (short) 0;
	}

	public byte getAlgorithm() {
		return 0;
	}

	public short getLength() throws CryptoException {
		return SIGNATURE_LENGTH;
	}

	public void update(byte[] buffer, short off, short length)	throws CryptoException {
		for (short i=off; i<(short) (off+length); i++) {
			signature[offset] ^= buffer[i];
			offset = (short) ((short) (offset+1) % SIGNATURE_LENGTH);
		}
	}

	public short sign(byte inBuff[], short inOffset, short inLength, byte outBuff[], short outOffset) throws CryptoException {
		update(inBuff, inOffset, inLength);
		Util.arrayCopy(signature, (short) 0, outBuff, outOffset, SIGNATURE_LENGTH);
		return SIGNATURE_LENGTH;
	}

	public boolean verify(byte inBuff[], short inOffset, short inLength, byte sigBuff[], short sigOffset, short sigLength)	throws CryptoException {
		update(inBuff, inOffset, inLength);
		return Util.arrayCompare(sigBuff, sigOffset, signature, (short) 0, SIGNATURE_LENGTH) == 0;
	}

	public static final byte ALG_DES_MAC4_NOPAD = 1;
	public static final byte ALG_DES_MAC8_NOPAD = 2;
	public static final byte ALG_DES_MAC4_ISO9797_M1 = 3;
	public static final byte ALG_DES_MAC8_ISO9797_M1 = 4;
	public static final byte ALG_DES_MAC4_ISO9797_M2 = 5;
	public static final byte ALG_DES_MAC8_ISO9797_M2 = 6;
	public static final byte ALG_DES_MAC4_PKCS5 = 7;
	public static final byte ALG_DES_MAC8_PKCS5 = 8;
	public static final byte ALG_RSA_SHA_ISO9796 = 9;
	public static final byte ALG_RSA_SHA_PKCS1 = 10;
	public static final byte ALG_RSA_MD5_PKCS1 = 11;
	public static final byte ALG_RSA_RIPEMD160_ISO9796 = 12;
	public static final byte ALG_RSA_RIPEMD160_PKCS1 = 13;
	public static final byte ALG_DSA_SHA = 14;
	public static final byte ALG_RSA_SHA_RFC2409 = 15;
	public static final byte ALG_RSA_MD5_RFC2409 = 16;
	public static final byte ALG_ECDSA_SHA = 17;
	public static final byte ALG_AES_MAC_128_NOPAD = 18;
	public static final byte ALG_DES_MAC4_ISO9797_1_M2_ALG3 = 19;
	public static final byte ALG_DES_MAC8_ISO9797_1_M2_ALG3 = 20;
	public static final byte ALG_RSA_SHA_PKCS1_PSS = 21;
	public static final byte ALG_RSA_MD5_PKCS1_PSS = 22;
	public static final byte ALG_RSA_RIPEMD160_PKCS1_PSS = 23;
	public static final byte MODE_SIGN = 1;
	public static final byte MODE_VERIFY = 2;
}
