package javacardx.crypto;

import javacard.security.*;

public class XORCipher extends Cipher {
	private byte[] key;
	private short keyIndex;

	public XORCipher() {
		super();
		key = new byte[8];
	}

	public void init(Key theKey, byte theMode) throws CryptoException {
		if (theKey instanceof XORKey)
			((XORKey) theKey).getKey(key, (short) 0);
		else if (theKey instanceof XORPrivateKey)
			((XORPrivateKey) theKey).getEncoded(key, (short) 0);
		else if (theKey instanceof XORPublicKey)
			((XORPublicKey) theKey).getEncoded(key, (short) 0);
		keyIndex = (short) 0;
	}

	public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
		init(theKey, theMode);
	}

	public byte getAlgorithm() {
		return (byte) 0x50;
	}

	public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
		return update(inBuff, inOffset, inLength, outBuff, outOffset);
	}

	public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
		for (short i=inOffset; i<(short) (inLength+inOffset); i++) {
			outBuff[outOffset++] = (byte) (key[keyIndex] ^ inBuff[i]);
//			key[keyIndex] ^= outBuff[outOffset++];
			keyIndex = (short) ((short) ((short) (keyIndex+1) % key.length));
		}
		return inLength;
	}
}
