package jason.terminal;

import com.sun.javacard.ocfrmiclientimpl.OCFCardAccessor;
import java.io.IOException;
import java.rmi.Remote;

public class RemoteCardAccessorImpl extends OCFCardAccessor implements RemoteCardAccessor {
	public byte[] exchangeAPDU(byte[] sendData) throws IOException {
		System.out.println("RemoteCardAccessor send:    " + arrayToString(sendData));
		byte[] receiveData = super.exchangeAPDU(sendData);
		System.out.println("RemoteCardAccessor receive: " + arrayToString(receiveData));
		return receiveData;
	}

	private static String arrayToString(byte[] data) {
		StringBuffer buffer = new StringBuffer();
		if (data != null)
			for (int i=0; i<data.length; i++) {
				String str = Integer.toHexString(data[i] & 0xFF);
				if (str.length() < 2)
					buffer.append('0');
				buffer.append(str);
				buffer.append(' ');
			}
		return buffer.toString();
	}
}