package jason.client;

import java.security.PublicKey;

public class XORPublicKey implements PublicKey {
	private byte[] key;

	public XORPublicKey(byte[] key) {
		this.key = key;
	}

	public XORPublicKey(XORPrivateKey key) {
		byte[] privateKey = key.getEncoded();
		this.key = new byte[privateKey.length/2];
		for (int i=0; i<privateKey.length/2; i++)
			this.key[i] = (byte) (privateKey[2*i] ^ privateKey[2*i+1]);
	}

	public String getAlgorithm() {
		return "XOR";
	}
	public String getFormat() {
		/**@todo: Implement this java.security.Key method*/
		throw new java.lang.UnsupportedOperationException("Method getFormat() not yet implemented.");
	}
	public byte[] getEncoded() {
		return key;
	}
}