package jason.client;

import java.security.*;

public class XORSignature extends SignatureSpi {
	private XORPrivateKey privateKey;
	private XORPublicKey publicKey;
	private static final int SIGNATURE_LENGTH = 8;
	private int offset;
	private byte[] buffer;

	public XORSignature() {
		buffer = new byte[SIGNATURE_LENGTH];
		offset = 0;
	}

	public boolean engineVerify(byte[] signature) throws SignatureException {
		return java.util.Arrays.equals(signature, buffer);
	}

	public Object engineGetParameter(String param) throws InvalidParameterException {
		/**@todo: implement this SignatureSpi abstract method*/
		return null;
	}

	public void engineSetParameter(String param, Object value) throws InvalidParameterException {
		/**@todo: implement this .SignatureSpi abstract method*/
	}

	public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
		this.privateKey = (XORPrivateKey) privateKey;
		publicKey = new XORPublicKey(this.privateKey);
		for (int i=0; i<SIGNATURE_LENGTH; i++)
			buffer[i] = (byte) 0;
		offset = 0;
		byte[] key = publicKey.getEncoded();
		try {
			engineUpdate(key, 0, key.length);
		}
		catch (SignatureException e) {
			e.printStackTrace();
		}
	}

	public byte[] engineSign() throws SignatureException {
		return buffer;
	}

	public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
		privateKey = null;
		this.publicKey = (XORPublicKey) publicKey;
		for (int i=0; i<SIGNATURE_LENGTH; i++)
			buffer[i] = (byte) 0;
		offset = 0;
		byte[] key = publicKey.getEncoded();
		try {
			engineUpdate(key, 0, key.length);
		}
		catch (SignatureException e) {
			e.printStackTrace();
		}
	}

	public void engineUpdate(byte b) throws SignatureException {
		buffer[offset] ^= b;
		offset = (offset+1) % SIGNATURE_LENGTH;
	}

	public void engineUpdate(byte[] data, int off, int length) throws SignatureException {
		for (int i=off; i<off+length; i++)
			engineUpdate(data[i]);
	}
}