package example.client;

import jason.client.*;
import java.io.*;
import javacard.framework.UserException;
import example.purse.Purse;
import example.purse.PurseImpl;

/**
 * <p>Title: Javacard As Secure Object Store</p>
 * <p>
 *   Description: The main program on the client computer. Before starting this
 *   program, the {@link jason.terminal.Main Terminal} should be running with
 *   the smartcard already inserted.
 * </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University of Twente</p>
 * @author Richard Brinkman
 * @version 1.0
 */
public class Client {

	/**
	 * Reads the keystore, connects to the terminal, logs in to the server applet
	 * and makes some secure method calls.
	 * @param args Command line parameters are ignored
	 * @throws Exception when something goes wrong
	 */
	public static void main(String[] args) throws Exception {
		KeyStore keyStore = KeyStore.load(new FileInputStream("keystore.dat"));

		Ans ans = new Ans(keyStore);
		try {
			Purse purse = (Purse) ans.getApplet("jcrmi.server.Purse", Purse.ROLE_BANK);
			System.out.println("\npurse.getBalance()");
			System.out.println("Balance: " + Integer.toHexString(purse.getBalance()));
			System.out.println("\npurse.increaseBalance()");
			purse.increaseBalance((short) 25);
			System.out.println("Balance after increase: " + Integer.toHexString(purse.getBalance()));

			System.out.println("\npurse.decreaseBalance()");
			purse.decreaseBalance((short) 12);
			System.out.println("Balance after decrease: " + Integer.toHexString(purse.getBalance()));
		}
		catch (UserException ue) {
			switch (ue.getReason()) {
				case PurseImpl.NEGATIVE_VALUE:
					System.out.println("You cannot increase or decrease the balance with a negative amount.");
					break;
				case PurseImpl.OVERFLOW:
					System.out.println("Maximum amount is reached.");
					break;
				case PurseImpl.UNDERFLOW:
					System.out.println("Negative balance not allowed");
			}
		}
		catch (LoginException le) {
			System.out.println(le.getMessage());
		}
		catch (InvalidFreshnessCounterException ifce) {
			System.out.println("Freshness error: " + ifce.getMessage());
		}
		finally {
			try {
				keyStore.store(new FileOutputStream("keystore.dat"));
			}
			catch (IOException ioe) {
				System.out.println("Cannot write keystore.dat: " + ioe.getMessage());
			}
		}
	}

	private static String arrayToString(byte[] data) {
		StringBuffer buffer = new StringBuffer();
		if (data != null)
			for (int i=0; i<data.length; i++) {
				String str = Integer.toHexString(data[i] & 0xFF);
				if (str.length() < 2)
					buffer.append('0');
				buffer.append(str);
				buffer.append(' ');
			}
		return buffer.toString();
	}
}