package jason.server;

import javacard.security.Key;

/**
 * <p>Title: Javacards As Secure Object Store</p>
 * <p>Description: KeyStore to be used inside a Javacard</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University of Twente</p>
 * @author Richard Brinkman
 * @version 1.0
 */
public class KeyStore {
	private Key[] keys;
	private byte[] sessionAlgorithms;
	public byte[] freshnessCounters;

	/**
	 * Makes a new key store containing <code>numberOfRoles</code> keys.
	 * @param numberOfRoles Size of the internal <code>Key[]</code>
	 */
	public KeyStore(short numberOfRoles) {
		keys = new Key[numberOfRoles];
		sessionAlgorithms = new byte[numberOfRoles];
		freshnessCounters = new byte[numberOfRoles];
		for (short i=0; i<numberOfRoles; i++) {
			keys[i] = null;
			sessionAlgorithms[i] = 0;
			freshnessCounters[i] = 0;
		}
	}

	/**
	 * Returns the key corresponding to the <code>role</code>.
	 * @param role Role byte
	 * @return Corresponding key
	 */
	public Key getKey(byte role) {
		return keys[role];
	}

	/**
	 * Sets a new entry for a new role
	 * @param role The role value (constant of the generated interface)
	 * @param key Some key
	 * @param sessionAlgorithm A value from KeyBuiler.TYPE_...
	 * @return false if the key cannot be set, true otherwise
	 */
	public boolean setKey(byte role, Key key, byte sessionAlgorithm) {
		if (keys==null || role < 0 || role >= keys.length || keys[role] != null)
			return false;
		keys[role] = key;
		sessionAlgorithms[role] = sessionAlgorithm;
		return true;
	}
}