package javacard.security;

import javacard.framework.Util;

public class XORPrivateKey implements Key {
	private byte[] key;

	public XORPrivateKey(byte[] privateKey, short offset, short length) {
		key = new byte[length];
		Util.arrayCopy(privateKey, offset, key, (short) 0, length);
	}

	public boolean isInitialized() {
		return true;
	}

	public void clearKey() {
		for (short i=0; i<key.length; i++)
			key[i] = (byte) 0;
	}

	public byte getType() {
		return (byte) 0x88; //Zo maar wat
	}

	public short getSize() {
		return (short) (8*key.length);
	}

	public byte[] getEncoded() {
		return key;
	}

	public void getEncoded(byte[] output, short offset) {
		for (short i=0; i<(short) key.length; i++)
			output[(short) (i+offset)] = key[i];
	}
}