package javacard.security;

public class XORPublicKey implements Key {
	private byte[] key;

	public XORPublicKey(byte[] buffer, short offset, short length) {
		key = new byte[length];
		for (short i=0; i<length; i++)
			key[i] = buffer[(short) (i+offset)];
	}

	public boolean isInitialized() {
		return true;
	}

	public void clearKey() {
		for (short i=0; i<key.length; i++)
			key[i] = (byte) 0;
	}

	public byte getType() {
		return (byte) 0x89; //Zo maar wat
	}

	public short getSize() {
		return (short) (8*key.length);
	}

	public byte[] getEncoded() {
		return key;
	}

	public void getEncoded(byte[] output, short offset) {
		for (short i=0; i<(short) key.length; i++)
			output[(short) (i+offset)] = key[i];
	}
}